/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.function.Consumer;
import org.jboss.as.controller.AbstractControllerService;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class ControlledProcessStateService
implements ProcessStateNotifier {
    @Deprecated
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"controlled-process-state"});
    public static final ServiceName INTERNAL_SERVICE_NAME = AbstractControllerService.PROCESS_STATE_NOTIFIER_CAPABILITY.getCapabilityServiceName();
    private ControlledProcessState.State processState;
    private final PropertyChangeSupport changeSupport;

    public static ProcessStateNotifier addService(ServiceTarget target, ControlledProcessState processState) {
        ControlledProcessStateService notifier = processState.getService();
        ServiceBuilder sb = target.addService();
        Consumer consumer = sb.provides(new ServiceName[]{INTERNAL_SERVICE_NAME, SERVICE_NAME});
        sb.setInstance(Service.newInstance((Consumer)consumer, (Object)notifier));
        sb.install();
        return notifier;
    }

    ControlledProcessStateService(ControlledProcessState.State initialState) {
        this.processState = initialState;
        this.changeSupport = new PropertyChangeSupport(this);
    }

    @Override
    public ControlledProcessState.State getCurrentState() {
        return this.processState;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    synchronized void stateChanged(ControlledProcessState.State newState) {
        ControlledProcessState.State oldState = this.processState;
        this.processState = newState;
        this.changeSupport.firePropertyChange("currentState", (Object)oldState, (Object)newState);
    }
}

