/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederation;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConfiguration;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Link;

public class AMQPFederationTarget
extends AMQPFederation {
    private final AMQPConnectionContext connection;
    private final AMQPFederationConfiguration configuration;

    public AMQPFederationTarget(String name, AMQPFederationConfiguration configuration, AMQPSessionContext session, ActiveMQServer server) {
        super(name, server);
        Objects.requireNonNull(session, "Provided session instance cannot be null");
        this.session = session;
        this.connection = session.getAMQPConnectionContext();
        this.connection.addLinkRemoteCloseListener(this.getName(), this::handleLinkRemoteClose);
        this.configuration = configuration;
    }

    @Override
    public AMQPConnectionContext getConnectionContext() {
        return this.connection;
    }

    @Override
    public AMQPSessionContext getSessionContext() {
        return this.session;
    }

    @Override
    public int getReceiverCredits() {
        return this.configuration.getReceiverCredits();
    }

    @Override
    public int getReceiverCreditsLow() {
        return this.configuration.getReceiverCreditsLow();
    }

    @Override
    public int getLargeMessageThreshold() {
        return this.configuration.getLargeMessageThreshold();
    }

    @Override
    public int getLinkAttachTimeout() {
        return this.configuration.getLinkAttachTimeout();
    }

    @Override
    public boolean isCoreMessageTunnelingEnabled() {
        return this.configuration.isCoreMessageTunnelingEnabled();
    }

    @Override
    protected void handleFederationStarted() throws ActiveMQException {
        try {
            this.session.getSessionSPI().addMetaData("federation-name", this.getName());
        }
        catch (ActiveMQAMQPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ActiveMQAMQPInternalErrorException("Error while configuring interal session metadata");
        }
        super.handleFederationStarted();
    }

    private void handleLinkRemoteClose(Link link) {
        Connection protonConnection = link.getSession().getConnection();
        if (protonConnection.getLocalState() != EndpointState.ACTIVE) {
            return;
        }
        if (link.getLocalState() != EndpointState.ACTIVE) {
            return;
        }
        if (!this.invokeLinkClosedInterceptors(link)) {
            this.signalError((Exception)((Object)new ActiveMQAMQPInternalErrorException("Federation link closed unexpectedly: " + link.getName())));
        }
    }

    @Override
    protected void signalResourceCreateError(Exception cause) {
        this.signalError(cause);
    }

    @Override
    protected void signalError(Exception cause) {
        String description = cause.getMessage();
        Symbol condition = cause instanceof ActiveMQAMQPException ? ((ActiveMQAMQPException)((Object)cause)).getAmqpError() : AmqpError.INTERNAL_ERROR;
        this.connection.close(new ErrorCondition(condition, description));
    }
}

