/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.server.services.net.OutboundSocketBindingService;

public class LocalDestinationOutboundSocketBindingService
extends OutboundSocketBindingService {
    private final Supplier<SocketBinding> localDestinationSocketBindingSupplier;

    public LocalDestinationOutboundSocketBindingService(Consumer<OutboundSocketBinding> outboundSocketBindingConsumer, Supplier<SocketBindingManager> socketBindingManagerSupplier, Supplier<NetworkInterfaceBinding> sourceInterfaceSupplier, Supplier<SocketBinding> localDestinationSocketBindingSupplier, String name, Integer sourcePort, boolean fixedSourcePort) {
        super(outboundSocketBindingConsumer, socketBindingManagerSupplier, sourceInterfaceSupplier, name, sourcePort, fixedSourcePort);
        this.localDestinationSocketBindingSupplier = localDestinationSocketBindingSupplier;
    }

    @Override
    protected OutboundSocketBinding createOutboundSocketBinding() {
        InetAddress destinationAddress = this.getDestinationAddress();
        int destinationPort = this.getDestinationPort();
        return new OutboundSocketBinding(this.outboundSocketName, (SocketBindingManager)this.socketBindingManagerSupplier.get(), destinationAddress, destinationPort, this.sourceInterfaceSupplier != null ? (NetworkInterfaceBinding)this.sourceInterfaceSupplier.get() : null, this.sourcePort, this.fixedSourcePort);
    }

    private InetAddress getDestinationAddress() {
        SocketBinding localDestinationSocketBinding = this.localDestinationSocketBindingSupplier.get();
        return localDestinationSocketBinding.getSocketAddress().getAddress();
    }

    private int getDestinationPort() {
        SocketBinding localDestinationSocketBinding = this.localDestinationSocketBindingSupplier.get();
        InetSocketAddress socketAddress = localDestinationSocketBinding.getSocketAddress();
        return socketAddress.getPort();
    }
}

