/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.xts.logging;

import jakarta.xml.ws.handler.MessageContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.xts.XTSException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.msc.service.StartException;

@MessageLogger(projectCode="WFLYXTS", length=4)
public interface XtsAsLogger
extends BasicLogger {
    public static final XtsAsLogger ROOT_LOGGER = (XtsAsLogger)Logger.getMessageLogger(XtsAsLogger.class, (String)"org.jboss.as.xts");

    @Message(id=1, value="TxBridge inbound recovery service start failed")
    public StartException txBridgeInboundRecoveryServiceFailedToStart();

    @Message(id=2, value="TxBridge outbound recovery service start failed")
    public StartException txBridgeOutboundRecoveryServiceFailedToStart();

    @Message(id=3, value="XTS service start failed")
    public StartException xtsServiceFailedToStart();

    @Message(id=4, value="Service not started")
    public IllegalStateException xtsServiceIsNotStarted();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=9, value="Rejecting call because it is not part of any XTS transaction")
    public void rejectingCallBecauseNotPartOfXtsTx();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10, value="Cannot get transaction status on handling context %s")
    public void cannotGetTransactionStatus(MessageContext var1, @Cause Throwable var2);

    @Message(id=11, value="Unexpected bridge type: '%s'")
    public XTSException unexpectedBridgeType(String var1);

    @Message(id=12, value="Error processing endpoint '%s'")
    public DeploymentUnitProcessingException errorProcessingEndpoint(String var1, @Cause Throwable var2);
}

