/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.puparser;

import java.util.HashMap;
import java.util.Map;

public enum Version {
    UNKNOWN(null, null),
    JPA_1_0("http://java.sun.com/xml/ns/persistence/persistence_1_0.xsd", "1.0"),
    JPA_2_0("http://java.sun.com/xml/ns/persistence/persistence_2_0.xsd", "2.0"),
    JPA_2_1("http://xmlns.jcp.org/xml/ns/persistence/persistence_2_1.xsd", "2.1"),
    JPA_2_2("http://xmlns.jcp.org/xml/ns/persistence/persistence_2_2.xsd", "2.2"),
    JPA_3_0("https://jakarta.ee/xml/ns/persistence/persistence_3_0.xsd", "3.0");

    private static final Map<String, Version> locationBindings;
    private static final Map<String, Version> versionBindings;
    private final String location;
    private final String version;

    private Version(String location, String version) {
        this.location = location;
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public static Version forLocation(String location) {
        Version version = locationBindings.get(location);
        return version != null ? version : UNKNOWN;
    }

    public static Version forVersion(String version) {
        Version result = versionBindings.get(version);
        return result != null ? result : UNKNOWN;
    }

    static {
        locationBindings = new HashMap<String, Version>();
        versionBindings = new HashMap<String, Version>();
        for (Version version : Version.values()) {
            locationBindings.put(version.location, version);
            versionBindings.put(version.version, version);
        }
    }
}

