/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.MultiValueMode;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.sort.impl.AbstractLuceneReversibleSort;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortCollector;
import org.hibernate.search.backend.lucene.search.sort.impl.SortRequestContext;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneFieldComparatorSource;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.sort.dsl.SortOrder;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public abstract class AbstractLuceneDocumentValueSort
extends AbstractLuceneReversibleSort {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String absoluteFieldPath;
    private final LuceneSearchPredicate nestedFilter;
    private final String nestedDocumentPath;
    private final MultiValueMode multiValueMode;

    protected AbstractLuceneDocumentValueSort(AbstractBuilder builder) {
        super(builder);
        this.absoluteFieldPath = builder.absoluteFieldPath;
        this.nestedFilter = builder.nestedFilter;
        this.nestedDocumentPath = builder.nestedDocumentPath;
        this.multiValueMode = builder.getMultiValueMode();
    }

    @Override
    public void toSortFields(LuceneSearchSortCollector collector) {
        LuceneFieldComparatorSource fieldComparatorSource = this.createFieldComparatorSource(collector);
        SortField sortField = new SortField(this.absoluteFieldPath, (FieldComparatorSource)fieldComparatorSource, this.order == SortOrder.DESC);
        collector.collectSortField(sortField);
    }

    private LuceneFieldComparatorSource createFieldComparatorSource(LuceneSearchSortCollector collector) {
        Query nestedFilter = this.getNestedFilter(collector);
        return this.doCreateFieldComparatorSource(this.nestedDocumentPath, this.multiValueMode, nestedFilter);
    }

    protected abstract LuceneFieldComparatorSource doCreateFieldComparatorSource(String var1, MultiValueMode var2, Query var3);

    private Query getNestedFilter(SortRequestContext context) {
        return this.nestedFilter == null ? null : this.nestedFilter.toQuery(context.toPredicateRequestContext(this.nestedDocumentPath));
    }

    public static abstract class AbstractBuilder
    extends AbstractLuceneReversibleSort.AbstractBuilder {
        protected final String absoluteFieldPath;
        protected final String nestedDocumentPath;
        private SortMode mode;
        protected LuceneSearchPredicate nestedFilter;

        protected AbstractBuilder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<?> field) {
            this(scope, field.absolutePath(), field.nestedDocumentPath());
        }

        protected AbstractBuilder(LuceneSearchIndexScope<?> scope, String absoluteFieldPath, String nestedDocumentPath) {
            super(scope);
            this.absoluteFieldPath = absoluteFieldPath;
            this.nestedDocumentPath = nestedDocumentPath;
        }

        public void mode(SortMode mode) {
            if (this.nestedDocumentPath != null && SortMode.MEDIAN.equals((Object)mode)) {
                throw log.invalidSortModeAcrossNested(mode, this.getEventContext());
            }
            this.mode = mode;
        }

        public void filter(SearchPredicate filter) {
            if (this.nestedDocumentPath == null) {
                throw log.cannotFilterSortOnRootDocumentField(this.absoluteFieldPath, this.getEventContext());
            }
            LuceneSearchPredicate luceneFilter = LuceneSearchPredicate.from(this.scope, filter);
            luceneFilter.checkNestableWithin(this.nestedDocumentPath);
            this.nestedFilter = luceneFilter;
        }

        private MultiValueMode getMultiValueMode() {
            MultiValueMode multiValueMode;
            if (this.mode == null) {
                multiValueMode = this.order == SortOrder.DESC ? MultiValueMode.MAX : MultiValueMode.MIN;
            } else {
                switch (this.mode) {
                    case MIN: {
                        multiValueMode = MultiValueMode.MIN;
                        break;
                    }
                    case MAX: {
                        multiValueMode = MultiValueMode.MAX;
                        break;
                    }
                    case AVG: {
                        multiValueMode = MultiValueMode.AVG;
                        break;
                    }
                    case SUM: {
                        multiValueMode = MultiValueMode.SUM;
                        break;
                    }
                    case MEDIAN: {
                        multiValueMode = MultiValueMode.MEDIAN;
                        break;
                    }
                    default: {
                        throw new AssertionFailure("Unexpected sort mode: " + this.mode);
                    }
                }
            }
            return multiValueMode;
        }

        protected final EventContext getEventContext() {
            return EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath);
        }
    }
}

