/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.config;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.utils.BufferHelper;

public class PersistedKeyValuePair
implements EncodingSupport {
    private long storeId;
    private String mapId;
    private String key;
    private String value;

    public PersistedKeyValuePair() {
    }

    public PersistedKeyValuePair(String mapId, String key, String value) {
        this.mapId = mapId;
        this.key = key;
        this.value = value;
    }

    public void setStoreId(long id) {
        this.storeId = id;
    }

    public long getStoreId() {
        return this.storeId;
    }

    public String getMapId() {
        return this.mapId;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public int getEncodeSize() {
        int size = 0;
        size += BufferHelper.sizeOfString((String)this.mapId);
        size += BufferHelper.sizeOfString((String)this.key);
        return size += BufferHelper.sizeOfString((String)this.value);
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeString(this.mapId);
        buffer.writeString(this.key);
        buffer.writeString(this.value);
    }

    public void decode(ActiveMQBuffer buffer) {
        this.mapId = buffer.readString();
        this.key = buffer.readString();
        this.value = buffer.readString();
    }

    public String toString() {
        return "PersistedKeyValuePair [storeId=" + this.storeId + ", mapId=" + this.mapId + ", key=" + this.key + ", value=" + this.value + "]";
    }
}

