/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean;

import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReferences;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.environment.bean.BeanRetrieval;
import org.hibernate.search.engine.environment.bean.CastingBeanReference;
import org.hibernate.search.engine.environment.bean.InstanceBeanReference;
import org.hibernate.search.engine.environment.bean.TypeAndNameBeanReference;
import org.hibernate.search.engine.environment.bean.TypeBeanReference;
import org.hibernate.search.util.common.impl.StringHelper;

public interface BeanReference<T> {
    public BeanHolder<T> resolve(BeanResolver var1);

    default public <U> BeanReference<? extends U> asSubTypeOf(Class<U> expectedType) {
        return new CastingBeanReference<U>(this, expectedType);
    }

    public static <T> BeanReference<T> of(Class<T> type) {
        return BeanReference.of(type, BeanRetrieval.ANY);
    }

    public static <T> BeanReference<T> of(Class<T> type, BeanRetrieval retrieval) {
        return new TypeBeanReference<T>(type, retrieval);
    }

    public static <T> BeanReference<T> of(Class<T> type, String name) {
        return BeanReference.of(type, name, BeanRetrieval.ANY);
    }

    public static <T> BeanReference<T> of(Class<T> type, String name, BeanRetrieval retrieval) {
        if (StringHelper.isNotEmpty((String)name)) {
            return new TypeAndNameBeanReference<T>(type, name, retrieval);
        }
        return new TypeBeanReference<T>(type, retrieval);
    }

    public static <T> BeanReference<T> ofInstance(T instance) {
        return new InstanceBeanReference<T>(instance);
    }

    public static BeanReference<?> parse(String value) {
        return BeanReference.parse(Object.class, value);
    }

    public static <T> BeanReference<T> parse(Class<T> expectedType, String value) {
        return BeanReferences.parse(expectedType, value);
    }
}

