/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.common;

import io.grpc.MethodDescriptor;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.buffer.impl.VertxByteBufAllocator;
import io.vertx.grpc.common.CodecException;
import io.vertx.grpc.common.GrpcMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

@VertxGen
public interface GrpcMessageDecoder<T> {
    public static final GrpcMessageDecoder<Buffer> IDENTITY = new GrpcMessageDecoder<Buffer>(){

        @Override
        public Buffer decode(GrpcMessage msg) {
            return msg.payload();
        }
    };
    public static final GrpcMessageDecoder<Buffer> GZIP = new GrpcMessageDecoder<Buffer>(){

        @Override
        public Buffer decode(GrpcMessage msg) throws CodecException {
            EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.GZIP)});
            channel.config().setAllocator(VertxByteBufAllocator.UNPOOLED_ALLOCATOR);
            try {
                ChannelFuture fut = channel.writeOneInbound((Object)msg.payload().getByteBuf());
                if (fut.isSuccess()) {
                    ByteBuf buf;
                    Buffer decoded = null;
                    while ((buf = (ByteBuf)channel.readInbound()) != null) {
                        if (decoded == null) {
                            decoded = Buffer.buffer((ByteBuf)buf);
                            continue;
                        }
                        decoded.appendBuffer(Buffer.buffer((ByteBuf)buf));
                    }
                    if (decoded == null) {
                        throw new CodecException("Invalid GZIP input");
                    }
                    Buffer buffer = decoded;
                    return buffer;
                }
                throw new CodecException(fut.cause());
            }
            finally {
                channel.close();
            }
        }
    };

    @GenIgnore(value={"permitted-type"})
    public static <T> GrpcMessageDecoder<T> unmarshaller(final MethodDescriptor.Marshaller<T> desc) {
        return new GrpcMessageDecoder<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T decode(GrpcMessage msg) {
                ByteArrayInputStream in = new ByteArrayInputStream(msg.payload().getBytes());
                Object object = desc.parse((InputStream)in);
                return object;
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
    }

    public T decode(GrpcMessage var1) throws CodecException;
}

