/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.client.impl.Paths;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.factory.impl.ElasticsearchWorkFactory;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractNonBulkableWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.work.impl.NonBulkableWork;
import org.hibernate.search.backend.elasticsearch.work.impl.RefreshWork;

public class DeleteByQueryWork
extends AbstractNonBulkableWork<Void> {
    private final NonBulkableWork<?> refreshWork;

    protected DeleteByQueryWork(Builder builder) {
        super(builder);
        this.refreshWork = builder.buildRefreshWork();
    }

    @Override
    protected CompletableFuture<?> beforeExecute(ElasticsearchWorkExecutionContext executionContext, ElasticsearchRequest request) {
        if (this.refreshWork != null) {
            return this.refreshWork.execute(executionContext);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        return null;
    }

    public static class Builder
    extends AbstractNonBulkableWork.AbstractBuilder<Builder> {
        private final URLEncodedString indexName;
        private final JsonObject payload;
        private final Set<URLEncodedString> typeNames = new HashSet<URLEncodedString>();
        private Collection<String> routingKeys;
        private final RefreshWork.Builder refreshWorkBuilder;

        public Builder(URLEncodedString indexName, JsonObject payload, ElasticsearchWorkFactory workFactory) {
            super(ElasticsearchRequestSuccessAssessor.DEFAULT_INSTANCE);
            this.indexName = indexName;
            this.payload = payload;
            this.refreshWorkBuilder = workFactory.isRefreshSupported() ? workFactory.refresh().index(indexName) : null;
        }

        public Builder routingKeys(Collection<String> routingKeys) {
            this.routingKeys = routingKeys;
            return this;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.post().pathComponent(this.indexName).param("conflicts", "proceed");
            if (!this.typeNames.isEmpty()) {
                builder.multiValuedPathComponent(this.typeNames);
            }
            if (this.routingKeys != null && !this.routingKeys.isEmpty()) {
                builder.multiValuedParam("routing", this.routingKeys);
            }
            builder.pathComponent(Paths._DELETE_BY_QUERY).body(this.payload);
            return builder.build();
        }

        protected NonBulkableWork<?> buildRefreshWork() {
            return this.refreshWorkBuilder != null ? this.refreshWorkBuilder.build() : null;
        }

        public DeleteByQueryWork build() {
            return new DeleteByQueryWork(this);
        }
    }
}

