/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.comp.SequenceComposer;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class JSONComposer<T>
extends SequenceComposer<JSONComposer<T>> {
    protected final int _features;
    protected final boolean _closeGenerator;
    protected T _result;
    protected SegmentedStringWriter _stringWriter;
    protected ByteArrayBuilder _byteWriter;

    public JSONComposer(int n, JsonGenerator jsonGenerator, boolean bl) {
        super(jsonGenerator);
        this._features = n;
        this._stringWriter = null;
        this._byteWriter = null;
        this._closeGenerator = bl;
    }

    protected JSONComposer(int n, JsonGenerator jsonGenerator, SegmentedStringWriter segmentedStringWriter) {
        super(jsonGenerator);
        this._features = n;
        this._stringWriter = segmentedStringWriter;
        this._byteWriter = null;
        this._closeGenerator = true;
    }

    protected JSONComposer(int n, JsonGenerator jsonGenerator, ByteArrayBuilder byteArrayBuilder) {
        super(jsonGenerator);
        this._features = n;
        this._stringWriter = null;
        this._byteWriter = byteArrayBuilder;
        this._closeGenerator = true;
    }

    protected JSONComposer(int n, T t) {
        super(null);
        this._features = n;
        this._result = t;
        this._stringWriter = null;
        this._byteWriter = null;
        this._closeGenerator = false;
    }

    public static <RESULT> JSONComposer<RESULT> streamComposer(int n, JsonGenerator jsonGenerator, boolean bl) {
        return new JSONComposer(n, jsonGenerator, bl);
    }

    public static JSONComposer<String> stringComposer(int n, JsonGenerator jsonGenerator, SegmentedStringWriter segmentedStringWriter) {
        return new JSONComposer<String>(n, jsonGenerator, segmentedStringWriter);
    }

    public static JSONComposer<byte[]> bytesComposer(int n, JsonGenerator jsonGenerator, ByteArrayBuilder byteArrayBuilder) {
        return new JSONComposer<byte[]>(n, jsonGenerator, byteArrayBuilder);
    }

    public static <T extends Collection<Object>> JSONComposer<T> collectionComposer(int n, T t) {
        return new JSONComposer<T>(n, t);
    }

    public static JSONComposer<Map<String, Object>> mapComposer(int n, Map<String, Object> map) {
        return new JSONComposer<Map<String, Object>>(n, map);
    }

    public T finish() throws IOException {
        if (this._open) {
            this._closeChild();
            this._open = false;
            if (this._closeGenerator) {
                this._generator.close();
            } else if (JSON.Feature.FLUSH_AFTER_WRITE_VALUE.isEnabled(this._features)) {
                this._generator.flush();
            }
        }
        if (this._result == null) {
            Object object;
            if (this._stringWriter != null) {
                object = this._stringWriter.getAndClear();
                this._stringWriter = null;
            } else if (this._byteWriter != null) {
                object = this._byteWriter.toByteArray();
                this._byteWriter = null;
            } else {
                object = this._generator.getOutputTarget();
            }
            this._result = object;
        }
        return this._result;
    }

    @Override
    protected JSONComposer<T> _start() throws IOException {
        throw this._illegalCall();
    }

    @Override
    protected Object _finish() throws IOException {
        throw this._illegalCall();
    }
}

