/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene99;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FlatVectorsWriter;
import org.apache.lucene.codecs.KnnFieldVectorsWriter;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.index.DocsWithFieldSet;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.TaskExecutor;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.hnsw.CloseableRandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.ConcurrentHnswMerger;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.HnswGraphBuilder;
import org.apache.lucene.util.hnsw.HnswGraphMerger;
import org.apache.lucene.util.hnsw.IncrementalHnswGraphMerger;
import org.apache.lucene.util.hnsw.NeighborArray;
import org.apache.lucene.util.hnsw.OnHeapHnswGraph;
import org.apache.lucene.util.hnsw.RandomAccessVectorValues;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.apache.lucene.util.packed.DirectMonotonicWriter;

public final class Lucene99HnswVectorsWriter
extends KnnVectorsWriter {
    private static final long SHALLOW_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Lucene99HnswVectorsWriter.class);
    private final SegmentWriteState segmentWriteState;
    private final IndexOutput meta;
    private final IndexOutput vectorIndex;
    private final int M;
    private final int beamWidth;
    private final FlatVectorsWriter flatVectorWriter;
    private final int numMergeWorkers;
    private final TaskExecutor mergeExec;
    private final List<FieldWriter<?>> fields = new ArrayList();
    private boolean finished;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene99HnswVectorsWriter(SegmentWriteState state, int M, int beamWidth, FlatVectorsWriter flatVectorWriter, int numMergeWorkers, TaskExecutor mergeExec) throws IOException {
        this.M = M;
        this.flatVectorWriter = flatVectorWriter;
        this.beamWidth = beamWidth;
        this.numMergeWorkers = numMergeWorkers;
        this.mergeExec = mergeExec;
        this.segmentWriteState = state;
        String metaFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vem");
        String indexDataFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vex");
        boolean success = false;
        try {
            this.meta = state.directory.createOutput(metaFileName, state.context);
            this.vectorIndex = state.directory.createOutput(indexDataFileName, state.context);
            CodecUtil.writeIndexHeader(this.meta, "Lucene99HnswVectorsFormatMeta", 0, state.segmentInfo.getId(), state.segmentSuffix);
            CodecUtil.writeIndexHeader(this.vectorIndex, "Lucene99HnswVectorsFormatIndex", 0, state.segmentInfo.getId(), state.segmentSuffix);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public KnnFieldVectorsWriter<?> addField(FieldInfo fieldInfo) throws IOException {
        FieldWriter<?> newField = FieldWriter.create(fieldInfo, this.M, this.beamWidth, this.segmentWriteState.infoStream);
        this.fields.add(newField);
        return this.flatVectorWriter.addField(fieldInfo, newField);
    }

    @Override
    public void flush(int maxDoc, Sorter.DocMap sortMap) throws IOException {
        this.flatVectorWriter.flush(maxDoc, sortMap);
        for (FieldWriter<?> field : this.fields) {
            if (sortMap == null) {
                this.writeField(field);
                continue;
            }
            this.writeSortingField(field, sortMap);
        }
    }

    @Override
    public void finish() throws IOException {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        this.flatVectorWriter.finish();
        if (this.meta != null) {
            this.meta.writeInt(-1);
            CodecUtil.writeFooter(this.meta);
        }
        if (this.vectorIndex != null) {
            CodecUtil.writeFooter(this.vectorIndex);
        }
    }

    @Override
    public long ramBytesUsed() {
        long total = SHALLOW_RAM_BYTES_USED;
        total += this.flatVectorWriter.ramBytesUsed();
        for (FieldWriter<?> field : this.fields) {
            total += field.ramBytesUsed();
        }
        return total;
    }

    private void writeField(FieldWriter<?> fieldData) throws IOException {
        long vectorIndexOffset = this.vectorIndex.getFilePointer();
        OnHeapHnswGraph graph = fieldData.getGraph();
        int[][] graphLevelNodeOffsets = this.writeGraph(graph);
        long vectorIndexLength = this.vectorIndex.getFilePointer() - vectorIndexOffset;
        this.writeMeta(fieldData.fieldInfo, vectorIndexOffset, vectorIndexLength, fieldData.docsWithField.cardinality(), graph, graphLevelNodeOffsets);
    }

    private void writeSortingField(FieldWriter<?> fieldData, Sorter.DocMap sortMap) throws IOException {
        int[] docIdOffsets = new int[sortMap.size()];
        int offset = 1;
        DocIdSetIterator iterator = fieldData.docsWithField.iterator();
        int docID = iterator.nextDoc();
        while (docID != Integer.MAX_VALUE) {
            int newDocID = sortMap.oldToNew(docID);
            docIdOffsets[newDocID] = offset++;
            docID = iterator.nextDoc();
        }
        DocsWithFieldSet newDocsWithField = new DocsWithFieldSet();
        int[] ordMap = new int[offset - 1];
        int[] oldOrdMap = new int[offset - 1];
        int ord = 0;
        int doc = 0;
        for (int docIdOffset : docIdOffsets) {
            if (docIdOffset != 0) {
                ordMap[ord] = docIdOffset - 1;
                oldOrdMap[docIdOffset - 1] = ord++;
                newDocsWithField.add(doc);
            }
            ++doc;
        }
        long vectorIndexOffset = this.vectorIndex.getFilePointer();
        OnHeapHnswGraph graph = fieldData.getGraph();
        int[][] graphLevelNodeOffsets = graph == null ? new int[][]{} : new int[graph.numLevels()][];
        HnswGraph mockGraph = this.reconstructAndWriteGraph(graph, ordMap, oldOrdMap, graphLevelNodeOffsets);
        long vectorIndexLength = this.vectorIndex.getFilePointer() - vectorIndexOffset;
        this.writeMeta(fieldData.fieldInfo, vectorIndexOffset, vectorIndexLength, fieldData.docsWithField.cardinality(), mockGraph, graphLevelNodeOffsets);
    }

    private HnswGraph reconstructAndWriteGraph(final OnHeapHnswGraph graph, int[] newToOldMap, int[] oldToNewMap, int[][] levelNodeOffsets) throws IOException {
        if (graph == null) {
            return null;
        }
        final ArrayList<int[]> nodesByLevel = new ArrayList<int[]>(graph.numLevels());
        nodesByLevel.add(null);
        int maxOrd = graph.size();
        HnswGraph.NodesIterator nodesOnLevel0 = graph.getNodesOnLevel(0);
        levelNodeOffsets[0] = new int[nodesOnLevel0.size()];
        while (nodesOnLevel0.hasNext()) {
            int node = nodesOnLevel0.nextInt();
            NeighborArray neighbors = graph.getNeighbors(0, newToOldMap[node]);
            long offset = this.vectorIndex.getFilePointer();
            this.reconstructAndWriteNeighbours(neighbors, oldToNewMap, maxOrd);
            levelNodeOffsets[0][node] = Math.toIntExact(this.vectorIndex.getFilePointer() - offset);
        }
        for (int level = 1; level < graph.numLevels(); ++level) {
            HnswGraph.NodesIterator nodesOnLevel = graph.getNodesOnLevel(level);
            int[] newNodes = new int[nodesOnLevel.size()];
            int n = 0;
            while (nodesOnLevel.hasNext()) {
                newNodes[n] = oldToNewMap[nodesOnLevel.nextInt()];
                ++n;
            }
            Arrays.sort(newNodes);
            nodesByLevel.add(newNodes);
            levelNodeOffsets[level] = new int[newNodes.length];
            int nodeOffsetIndex = 0;
            for (int node : newNodes) {
                NeighborArray neighbors = graph.getNeighbors(level, newToOldMap[node]);
                long offset = this.vectorIndex.getFilePointer();
                this.reconstructAndWriteNeighbours(neighbors, oldToNewMap, maxOrd);
                levelNodeOffsets[level][nodeOffsetIndex++] = Math.toIntExact(this.vectorIndex.getFilePointer() - offset);
            }
        }
        return new HnswGraph(){

            @Override
            public int nextNeighbor() {
                throw new UnsupportedOperationException("Not supported on a mock graph");
            }

            @Override
            public void seek(int level, int target) {
                throw new UnsupportedOperationException("Not supported on a mock graph");
            }

            @Override
            public int size() {
                return graph.size();
            }

            @Override
            public int numLevels() {
                return graph.numLevels();
            }

            @Override
            public int entryNode() {
                throw new UnsupportedOperationException("Not supported on a mock graph");
            }

            @Override
            public HnswGraph.NodesIterator getNodesOnLevel(int level) {
                if (level == 0) {
                    return graph.getNodesOnLevel(0);
                }
                return new HnswGraph.ArrayNodesIterator((int[])nodesByLevel.get(level), ((int[])nodesByLevel.get(level)).length);
            }
        };
    }

    private void reconstructAndWriteNeighbours(NeighborArray neighbors, int[] oldToNewMap, int maxOrd) throws IOException {
        int i;
        int size = neighbors.size();
        this.vectorIndex.writeVInt(size);
        int[] nnodes = neighbors.node();
        for (i = 0; i < size; ++i) {
            nnodes[i] = oldToNewMap[nnodes[i]];
        }
        Arrays.sort(nnodes, 0, size);
        for (i = size - 1; i > 0; --i) {
            assert (nnodes[i] < maxOrd) : "node too large: " + nnodes[i] + ">=" + maxOrd;
            int n = i;
            nnodes[n] = nnodes[n] - nnodes[i - 1];
        }
        for (i = 0; i < size; ++i) {
            this.vectorIndex.writeVInt(nnodes[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        block11: {
            CloseableRandomVectorScorerSupplier scorerSupplier;
            block10: {
                scorerSupplier = this.flatVectorWriter.mergeOneFieldToIndex(fieldInfo, mergeState);
                boolean success = false;
                try {
                    long vectorIndexOffset = this.vectorIndex.getFilePointer();
                    OnHeapHnswGraph graph = null;
                    int[][] vectorIndexNodeOffsets = null;
                    if (scorerSupplier.totalVectorCount() > 0) {
                        DocIdSetIterator mergedVectorIterator;
                        HnswGraphMerger merger = this.createGraphMerger(fieldInfo, scorerSupplier);
                        for (int i = 0; i < mergeState.liveDocs.length; ++i) {
                            merger.addReader(mergeState.knnVectorsReaders[i], mergeState.docMaps[i], mergeState.liveDocs[i]);
                        }
                        switch (fieldInfo.getVectorEncoding()) {
                            case BYTE: {
                                mergedVectorIterator = KnnVectorsWriter.MergedVectorValues.mergeByteVectorValues(fieldInfo, mergeState);
                                break;
                            }
                            case FLOAT32: {
                                mergedVectorIterator = KnnVectorsWriter.MergedVectorValues.mergeFloatVectorValues(fieldInfo, mergeState);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unsupported vector encoding: " + fieldInfo.getVectorEncoding());
                            }
                        }
                        graph = merger.merge(mergedVectorIterator, this.segmentWriteState.infoStream, scorerSupplier.totalVectorCount());
                        vectorIndexNodeOffsets = this.writeGraph(graph);
                    }
                    long vectorIndexLength = this.vectorIndex.getFilePointer() - vectorIndexOffset;
                    this.writeMeta(fieldInfo, vectorIndexOffset, vectorIndexLength, scorerSupplier.totalVectorCount(), graph, vectorIndexNodeOffsets);
                    success = true;
                    if (!success) break block10;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(scorerSupplier);
                    } else {
                        IOUtils.closeWhileHandlingException(scorerSupplier);
                    }
                    throw throwable;
                }
                IOUtils.close(scorerSupplier);
                break block11;
            }
            IOUtils.closeWhileHandlingException(scorerSupplier);
        }
    }

    private int[][] writeGraph(OnHeapHnswGraph graph) throws IOException {
        if (graph == null) {
            return new int[0][0];
        }
        int countOnLevel0 = graph.size();
        int[][] offsets = new int[graph.numLevels()][];
        for (int level = 0; level < graph.numLevels(); ++level) {
            int[] sortedNodes = HnswGraph.NodesIterator.getSortedNodes(graph.getNodesOnLevel(level));
            offsets[level] = new int[sortedNodes.length];
            int nodeOffsetId = 0;
            for (int node : sortedNodes) {
                int i;
                NeighborArray neighbors = graph.getNeighbors(level, node);
                int size = neighbors.size();
                long offsetStart = this.vectorIndex.getFilePointer();
                this.vectorIndex.writeVInt(size);
                int[] nnodes = neighbors.node();
                Arrays.sort(nnodes, 0, size);
                for (i = size - 1; i > 0; --i) {
                    assert (nnodes[i] < countOnLevel0) : "node too large: " + nnodes[i] + ">=" + countOnLevel0;
                    int n = i;
                    nnodes[n] = nnodes[n] - nnodes[i - 1];
                }
                for (i = 0; i < size; ++i) {
                    this.vectorIndex.writeVInt(nnodes[i]);
                }
                offsets[level][nodeOffsetId++] = Math.toIntExact(this.vectorIndex.getFilePointer() - offsetStart);
            }
        }
        return offsets;
    }

    private void writeMeta(FieldInfo field, long vectorIndexOffset, long vectorIndexLength, int count, HnswGraph graph, int[][] graphLevelNodeOffsets) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeInt(field.getVectorEncoding().ordinal());
        this.meta.writeInt(field.getVectorSimilarityFunction().ordinal());
        this.meta.writeVLong(vectorIndexOffset);
        this.meta.writeVLong(vectorIndexLength);
        this.meta.writeVInt(field.getVectorDimension());
        this.meta.writeInt(count);
        this.meta.writeVInt(this.M);
        if (graph == null) {
            this.meta.writeVInt(0);
        } else {
            this.meta.writeVInt(graph.numLevels());
            long valueCount = 0L;
            for (int level = 0; level < graph.numLevels(); ++level) {
                HnswGraph.NodesIterator nodesOnLevel = graph.getNodesOnLevel(level);
                valueCount += (long)nodesOnLevel.size();
                if (level > 0) {
                    int[] nol = new int[nodesOnLevel.size()];
                    int numberConsumed = nodesOnLevel.consume(nol);
                    Arrays.sort(nol);
                    assert (numberConsumed == nodesOnLevel.size());
                    this.meta.writeVInt(nol.length);
                    for (int i = nodesOnLevel.size() - 1; i > 0; --i) {
                        int n = i;
                        nol[n] = nol[n] - nol[i - 1];
                    }
                    for (int n : nol) {
                        assert (n >= 0) : "delta encoding for nodes failed; expected nodes to be sorted";
                        this.meta.writeVInt(n);
                    }
                    continue;
                }
                assert (nodesOnLevel.size() == count) : "Level 0 expects to have all nodes";
            }
            long start = this.vectorIndex.getFilePointer();
            this.meta.writeLong(start);
            this.meta.writeVInt(16);
            DirectMonotonicWriter memoryOffsetsWriter = DirectMonotonicWriter.getInstance(this.meta, this.vectorIndex, valueCount, 16);
            long cumulativeOffsetSum = 0L;
            int[][] nArray = graphLevelNodeOffsets;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[] levelOffsets;
                for (int v : levelOffsets = nArray[i]) {
                    memoryOffsetsWriter.add(cumulativeOffsetSum);
                    cumulativeOffsetSum += (long)v;
                }
            }
            memoryOffsetsWriter.finish();
            this.meta.writeLong(this.vectorIndex.getFilePointer() - start);
        }
    }

    private HnswGraphMerger createGraphMerger(FieldInfo fieldInfo, RandomVectorScorerSupplier scorerSupplier) {
        if (this.mergeExec != null) {
            return new ConcurrentHnswMerger(fieldInfo, scorerSupplier, this.M, this.beamWidth, this.mergeExec, this.numMergeWorkers);
        }
        return new IncrementalHnswGraphMerger(fieldInfo, scorerSupplier, this.M, this.beamWidth);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.meta, this.vectorIndex, this.flatVectorWriter);
    }

    private static class RAVectorValues<T>
    implements RandomAccessVectorValues<T> {
        private final List<T> vectors;
        private final int dim;

        RAVectorValues(List<T> vectors, int dim) {
            this.vectors = vectors;
            this.dim = dim;
        }

        @Override
        public int size() {
            return this.vectors.size();
        }

        @Override
        public int dimension() {
            return this.dim;
        }

        @Override
        public T vectorValue(int targetOrd) throws IOException {
            return this.vectors.get(targetOrd);
        }

        @Override
        public RandomAccessVectorValues<T> copy() throws IOException {
            return this;
        }
    }

    private static class FieldWriter<T>
    extends KnnFieldVectorsWriter<T> {
        private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(FieldWriter.class);
        private final FieldInfo fieldInfo;
        private final DocsWithFieldSet docsWithField;
        private final List<T> vectors;
        private final HnswGraphBuilder hnswGraphBuilder;
        private int lastDocID = -1;
        private int node = 0;

        static FieldWriter<?> create(FieldInfo fieldInfo, int M, int beamWidth, InfoStream infoStream) throws IOException {
            switch (fieldInfo.getVectorEncoding()) {
                case BYTE: {
                    return new FieldWriter(fieldInfo, M, beamWidth, infoStream);
                }
                case FLOAT32: {
                    return new FieldWriter(fieldInfo, M, beamWidth, infoStream);
                }
            }
            throw new IllegalStateException("Unsupported vector encoding: " + fieldInfo.getVectorEncoding());
        }

        FieldWriter(FieldInfo fieldInfo, int M, int beamWidth, InfoStream infoStream) throws IOException {
            RandomVectorScorerSupplier scorerSupplier;
            this.fieldInfo = fieldInfo;
            this.docsWithField = new DocsWithFieldSet();
            this.vectors = new ArrayList<T>();
            RAVectorValues<byte[]> raVectors = new RAVectorValues<byte[]>(this.vectors, fieldInfo.getVectorDimension());
            switch (fieldInfo.getVectorEncoding()) {
                case BYTE: {
                    scorerSupplier = RandomVectorScorerSupplier.createBytes(raVectors, fieldInfo.getVectorSimilarityFunction());
                    break;
                }
                case FLOAT32: {
                    scorerSupplier = RandomVectorScorerSupplier.createFloats(raVectors, fieldInfo.getVectorSimilarityFunction());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported vector encoding: " + fieldInfo.getVectorEncoding());
                }
            }
            this.hnswGraphBuilder = HnswGraphBuilder.create(scorerSupplier, M, beamWidth, HnswGraphBuilder.randSeed);
            this.hnswGraphBuilder.setInfoStream(infoStream);
        }

        @Override
        public void addValue(int docID, T vectorValue) throws IOException {
            if (docID == this.lastDocID) {
                throw new IllegalArgumentException("VectorValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
            }
            assert (docID > this.lastDocID);
            this.vectors.add(vectorValue);
            this.docsWithField.add(docID);
            this.hnswGraphBuilder.addGraphNode(this.node);
            ++this.node;
            this.lastDocID = docID;
        }

        @Override
        public T copyValue(T vectorValue) {
            throw new UnsupportedOperationException();
        }

        OnHeapHnswGraph getGraph() {
            if (this.node > 0) {
                return this.hnswGraphBuilder.getGraph();
            }
            return null;
        }

        @Override
        public long ramBytesUsed() {
            return SHALLOW_SIZE + this.docsWithField.ramBytesUsed() + (long)this.vectors.size() * (long)(RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER) + this.hnswGraphBuilder.getGraph().ramBytesUsed();
        }
    }
}

