/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.coordinator;

import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.logging.tsLogger;
import java.io.PrintWriter;

public class RecordList {
    protected AbstractRecord listHead;
    private AbstractRecord listTail;
    private int noEntries;

    public RecordList() {
        this.listHead = null;
        this.listTail = null;
        this.noEntries = 0;
    }

    public RecordList(RecordList copy) {
        this.listHead = copy.listHead;
        this.listTail = copy.listTail;
        this.noEntries = copy.noEntries;
    }

    public final AbstractRecord getFront() {
        AbstractRecord temp = this.listHead;
        if (this.noEntries == 1) {
            this.listTail = null;
            this.listHead = null;
            this.noEntries = 0;
        } else if (this.noEntries > 1) {
            this.listHead = this.listHead.getNext();
            this.listHead.setPrevious(null);
            temp.setNext(null);
            temp.setPrevious(null);
            --this.noEntries;
        }
        return temp;
    }

    public final AbstractRecord getRear() {
        AbstractRecord temp = this.listTail;
        if (this.noEntries == 1) {
            this.listTail = null;
            this.listHead = null;
            this.noEntries = 0;
        } else if (this.noEntries > 1) {
            this.listTail = this.listTail.getPrevious();
            this.listTail.setNext(null);
            temp.setPrevious(null);
            --this.noEntries;
        }
        return temp;
    }

    public AbstractRecord getNext(AbstractRecord current) {
        AbstractRecord rec = current.getNext();
        if (this.remove(rec)) {
            return rec;
        }
        return null;
    }

    public final boolean insert(AbstractRecord newRecord) {
        return this.insert(newRecord, this.listHead);
    }

    public final void print(PrintWriter strm) {
        AbstractRecord arp = this.listHead;
        for (int i = 0; i < this.noEntries; ++i) {
            strm.print(arp);
            arp = arp.getNext();
        }
    }

    public final void putFront(AbstractRecord newRecord) {
        if (this.listHead == null) {
            this.listHead = this.listTail = newRecord;
            newRecord.setNext(null);
            newRecord.setPrevious(null);
        } else {
            this.listHead.setPrevious(newRecord);
            newRecord.setPrevious(null);
            newRecord.setNext(this.listHead);
            this.listHead = newRecord;
        }
        ++this.noEntries;
    }

    public final void putRear(AbstractRecord newRecord) {
        if (this.listTail == null) {
            this.listHead = this.listTail = newRecord;
            newRecord.setNext(null);
            newRecord.setPrevious(null);
        } else {
            this.listTail.setNext(newRecord);
            newRecord.setPrevious(this.listTail);
            newRecord.setNext(null);
            this.listTail = newRecord;
        }
        ++this.noEntries;
    }

    public final AbstractRecord peekFront() {
        return this.listHead;
    }

    public final AbstractRecord peekRear() {
        return this.listTail;
    }

    public final AbstractRecord peekNext(AbstractRecord curr) {
        return curr.getNext();
    }

    public final boolean remove(AbstractRecord oldRecord) {
        if (oldRecord == null) {
            return false;
        }
        if (this.noEntries == 1) {
            this.listTail = null;
            this.listHead = null;
            this.noEntries = 0;
        } else if (this.noEntries > 1) {
            if (this.listHead == oldRecord) {
                this.listHead = this.listHead.getNext();
                if (this.listHead != null) {
                    this.listHead.setPrevious(null);
                }
                oldRecord.setNext(null);
                oldRecord.setPrevious(null);
            } else if (this.listTail == oldRecord) {
                this.listTail = this.listTail.getPrevious();
                if (this.listTail != null) {
                    this.listTail.setNext(null);
                }
                oldRecord.setNext(null);
                oldRecord.setPrevious(null);
            } else {
                if (oldRecord.getPrevious() != null) {
                    oldRecord.getPrevious().setNext(oldRecord.getNext());
                }
                if (oldRecord.getNext() != null) {
                    oldRecord.getNext().setPrevious(oldRecord.getPrevious());
                }
            }
            --this.noEntries;
        }
        return true;
    }

    public final int size() {
        return this.noEntries;
    }

    public String toString() {
        AbstractRecord rec;
        Object s = "RecordList:";
        if (rec == null) {
            s = (String)s + " empty";
        } else {
            for (rec = this.listHead; rec != null; rec = rec.getNext()) {
                s = (String)s + " " + rec.order();
            }
        }
        return s;
    }

    private final boolean insert(AbstractRecord newRecord, AbstractRecord startAt) {
        AbstractRecord current;
        for (current = startAt; current != null; current = current.getNext()) {
            if (newRecord.shouldMerge(current)) {
                if (tsLogger.logger.isTraceEnabled()) {
                    tsLogger.logger.trace((Object)("RecordList::insert(" + this + ") : merging " + newRecord.type() + " and " + current.type() + " for " + newRecord.order()));
                }
                newRecord.merge(current);
                this.replace(newRecord, current);
                return true;
            }
            if (newRecord.shouldReplace(current)) {
                if (tsLogger.logger.isTraceEnabled()) {
                    tsLogger.logger.trace((Object)("RecordList::insert(" + this + ") : replacing " + current.type() + " and " + newRecord.type() + " for " + newRecord.order()));
                }
                this.replace(newRecord, current);
                return true;
            }
            if (newRecord.shouldAdd(current)) {
                if (tsLogger.logger.isTraceEnabled()) {
                    tsLogger.logger.trace((Object)("RecordList::insert(" + this + ") : adding extra record of type " + newRecord.type() + " before " + current.type() + " for " + newRecord.order()));
                }
                this.insertBefore(newRecord, current);
                return true;
            }
            if (newRecord.shouldAlter(current)) {
                newRecord.alter(current);
            }
            if (newRecord.equals(current)) {
                return false;
            }
            if (!newRecord.lessThan(current)) continue;
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("RecordList::insert(" + this + ") : inserting " + newRecord.type() + " for " + newRecord.order() + " before " + current.type()));
            }
            this.insertBefore(newRecord, current);
            return true;
        }
        if (current == null) {
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("RecordList::insert(" + this + ") : appending " + newRecord.type() + " for " + newRecord.order()));
            }
            this.putRear(newRecord);
        } else {
            if (tsLogger.logger.isTraceEnabled()) {
                tsLogger.logger.trace((Object)("RecordList::insert(" + this + ") : inserting " + newRecord.type() + " for " + newRecord.order() + " before " + current.type() + " for " + current.order()));
            }
            this.insertBefore(newRecord, current);
        }
        return true;
    }

    private final void insertBefore(AbstractRecord newRecord, AbstractRecord before) {
        newRecord.setPrevious(before.getPrevious());
        newRecord.setNext(before);
        before.setPrevious(newRecord);
        if (newRecord.getPrevious() != null) {
            newRecord.getPrevious().setNext(newRecord);
        } else {
            this.listHead = newRecord;
        }
        ++this.noEntries;
    }

    private final void replace(AbstractRecord newRecord, AbstractRecord oldRecord) {
        newRecord.setPrevious(oldRecord.getPrevious());
        newRecord.setNext(oldRecord.getNext());
        if (newRecord.getPrevious() != null) {
            newRecord.getPrevious().setNext(newRecord);
        } else {
            this.listHead = newRecord;
        }
        if (newRecord.getNext() != null) {
            newRecord.getNext().setPrevious(newRecord);
        } else {
            this.listTail = newRecord;
        }
        oldRecord = null;
    }
}

