/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.reactive.messaging;

import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.JdkLoggerFactory;
import java.util.EnumSet;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.PersistentResourceXMLDescriptionReader;
import org.jboss.as.controller.PersistentResourceXMLDescriptionWriter;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.SubsystemResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.extension.microprofile.reactive.messaging.MicroProfileReactiveMessagingSubsystemDefinition;
import org.wildfly.extension.microprofile.reactive.messaging.MicroProfileReactiveMessagingSubsystemSchema;
import org.wildfly.security.manager.WildFlySecurityManager;

public class MicroProfileReactiveMessagingExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "microprofile-reactive-messaging-smallrye";
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"microprofile-reactive-messaging-smallrye");
    static final ParentResourceDescriptionResolver SUBSYSTEM_RESOLVER = new SubsystemResourceDescriptionResolver("microprofile-reactive-messaging-smallrye", MicroProfileReactiveMessagingExtension.class);
    static final String WELD_CAPABILITY_NAME = "org.wildfly.weld";
    static final String REACTIVE_STREAMS_OPERATORS_CAPABILITY_NAME = "org.wildfly.microprofile.reactive-streams-operators";
    static final String CONFIG_CAPABILITY_NAME = "org.wildfly.microprofile.config";
    protected static final ModelVersion VERSION_1_0_0;
    private static final ModelVersion CURRENT_MODEL_VERSION;
    private final PersistentResourceXMLDescription currentDescription = MicroProfileReactiveMessagingSubsystemSchema.CURRENT.getXMLDescription();

    public void initialize(ExtensionContext extensionContext) {
        ClassLoader cl = WildFlySecurityManager.getClassLoaderPrivileged(this.getClass());
        if (cl instanceof ModuleClassLoader) {
            ModuleLoader loader = ((ModuleClassLoader)cl).getModule().getModuleLoader();
            try {
                Module module = loader.loadModule("io.netty");
                InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)JdkLoggerFactory.INSTANCE);
            }
            catch (ModuleLoadException module) {
                // empty catch block
            }
        }
        SubsystemRegistration sr = extensionContext.registerSubsystem(SUBSYSTEM_NAME, CURRENT_MODEL_VERSION);
        sr.registerXMLElementWriter((XMLElementWriter)new PersistentResourceXMLDescriptionWriter(this.currentDescription));
        ManagementResourceRegistration root = sr.registerSubsystemModel((ResourceDefinition)new MicroProfileReactiveMessagingSubsystemDefinition());
        root.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE, false);
    }

    public void initializeParsers(ExtensionParsingContext extensionParsingContext) {
        for (MicroProfileReactiveMessagingSubsystemSchema schema : EnumSet.allOf(MicroProfileReactiveMessagingSubsystemSchema.class)) {
            MicroProfileReactiveMessagingSubsystemSchema reader = schema == MicroProfileReactiveMessagingSubsystemSchema.CURRENT ? new PersistentResourceXMLDescriptionReader(this.currentDescription) : schema;
            extensionParsingContext.setSubsystemXmlMapping(SUBSYSTEM_NAME, schema.getNamespace().getUri(), (XMLElementReader)reader);
        }
    }

    static {
        CURRENT_MODEL_VERSION = VERSION_1_0_0 = ModelVersion.create((int)1, (int)0, (int)0);
    }
}

