/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.metrics;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.extension.metrics.MetricID;
import org.wildfly.extension.metrics.MetricRegistry;
import org.wildfly.extension.metrics.WildFlyMetric;
import org.wildfly.extension.metrics.WildFlyMetricMetadata;

public class MetricRegistration {
    private final List<Runnable> registrationTasks = new ArrayList<Runnable>();
    private final List<MetricID> unregistrationTasks = new ArrayList<MetricID>();
    private final MetricRegistry registry;
    private final List<Runnable> cleanUpTasks = new ArrayList<Runnable>();

    public MetricRegistration(MetricRegistry registry) {
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register() {
        MetricRegistry metricRegistry = this.registry;
        synchronized (metricRegistry) {
            for (Runnable task : this.registrationTasks) {
                task.run();
            }
            this.registrationTasks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        MetricRegistry metricRegistry = this.registry;
        synchronized (metricRegistry) {
            for (MetricID id : this.unregistrationTasks) {
                this.registry.unregister(id);
            }
            this.unregistrationTasks.clear();
        }
        for (Runnable cleanupTask : this.cleanUpTasks) {
            cleanupTask.run();
        }
        this.cleanUpTasks.clear();
    }

    public void registerMetric(WildFlyMetric metric, WildFlyMetricMetadata metadata) {
        this.registry.registerMetric(metric, metadata);
    }

    public synchronized void addRegistrationTask(Runnable task) {
        this.registrationTasks.add(task);
    }

    public void addUnregistrationTask(MetricID metricID) {
        this.unregistrationTasks.add(metricID);
    }

    void addCleanUpTask(Runnable task) {
        this.cleanUpTasks.add(task);
    }
}

