/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.rpc;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeListener;
import org.infinispan.commons.stat.MetricInfo;
import org.infinispan.commons.stat.TimerTracker;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.logging.TraceException;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalMetricsConfiguration;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.JmxStatisticsExposer;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.jmx.annotations.Units;
import org.infinispan.metrics.impl.CustomMetricsSupplier;
import org.infinispan.metrics.impl.MetricUtils;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.XSiteResponse;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.commands.remote.XSiteCacheRequest;
import org.infinispan.xsite.metrics.XSiteMetricsCollector;

@MBean(objectName="RpcManager", description="Manages all remote calls to remote cache instances in the cluster.")
@Scope(value=Scopes.NAMED_CACHE)
public class RpcManagerImpl
implements RpcManager,
JmxStatisticsExposer,
CustomMetricsSupplier {
    public static final String OBJECT_NAME = "RpcManager";
    private static final Log log = LogFactory.getLog(RpcManagerImpl.class);
    @Inject
    Transport t;
    @Inject
    Configuration configuration;
    @Inject
    ComponentRef<CommandsFactory> cf;
    @Inject
    DistributionManager distributionManager;
    @Inject
    TimeService timeService;
    @Inject
    XSiteMetricsCollector xSiteMetricsCollector;
    private final Function<ReplicableCommand, ReplicableCommand> toCacheRpcCommand = this::toCacheRpcCommand;
    private final AttributeListener<Long> updateRpcOptions = this::updateRpcOptions;
    private final XSiteResponse.XSiteResponseCompleted xSiteResponseCompleted = this::registerXSiteTime;
    private final LongAdder replicationCount = new LongAdder();
    private final LongAdder replicationFailures = new LongAdder();
    private final LongAdder totalReplicationTime = new LongAdder();
    private boolean statisticsEnabled = false;
    private volatile RpcOptions syncRpcOptions;

    @Override
    public Collection<MetricInfo> getCustomMetrics(GlobalMetricsConfiguration configuration) {
        boolean histograms = configuration.histograms();
        ArrayList<MetricInfo> attributes = new ArrayList<MetricInfo>(7);
        if (histograms) {
            attributes.add((MetricInfo)MetricUtils.createTimer("CrossSiteReplicationTimes", "Cross Site Replication Times", (rpcManager, timerTracker) -> rpcManager.xSiteMetricsCollector.registerTimer((TimerTracker)timerTracker), null));
        } else {
            attributes.add((MetricInfo)MetricUtils.createFunctionTimer("CrossSiteReplicationTimes", "Cross Site Replication Times", (rpcManager, timerTracker) -> rpcManager.xSiteMetricsCollector.registerTimer((TimerTracker)timerTracker), null));
        }
        for (String site : this.xSiteMetricsCollector.sites()) {
            Map<String, String> tags = Map.of("site", site);
            if (configuration.namesAsTags()) {
                attributes.add((MetricInfo)MetricUtils.createGauge("AverageXSiteReplicationTimeToSite", "Average Cross-Site replication time to " + site, rpcManager -> rpcManager.getAverageXSiteReplicationTimeTo(site), tags));
                attributes.add((MetricInfo)MetricUtils.createGauge("MinimumXSiteReplicationTimeToSite", "Minimum Cross-Site replication time to " + site, rpcManager -> rpcManager.getMinimumXSiteReplicationTimeTo(site), tags));
                attributes.add((MetricInfo)MetricUtils.createGauge("MaximumXSiteReplicationTimeToSite", "Maximum Cross-Site replication time to " + site, rpcManager -> rpcManager.getMaximumXSiteReplicationTimeTo(site), tags));
                attributes.add((MetricInfo)MetricUtils.createGauge("NumberXSiteRequestsSentToSite", "Number of Cross-Site request sent to " + site, rpcManager -> rpcManager.getNumberXSiteRequestsSentTo(site), tags));
                attributes.add((MetricInfo)MetricUtils.createGauge("NumberXSiteRequestsReceivedFromSite", "Number of Cross-Site request received from " + site, rpcManager -> rpcManager.getNumberXSiteRequestsReceivedFrom(site), tags));
                if (histograms) {
                    attributes.add((MetricInfo)MetricUtils.createTimer("ReplicationTimesToSite", "Replication times to " + site, (rpcManager, timer) -> rpcManager.xSiteMetricsCollector.registerTimer(site, (TimerTracker)timer), tags));
                    continue;
                }
                attributes.add((MetricInfo)MetricUtils.createFunctionTimer("ReplicationTimesToSite", "Replication times to " + site, (rpcManager, timer) -> rpcManager.xSiteMetricsCollector.registerTimer(site, (TimerTracker)timer), tags));
                continue;
            }
            String lSite = site.toLowerCase();
            attributes.add((MetricInfo)MetricUtils.createGauge("AverageXSiteReplicationTimeTo_" + lSite, "Average Cross-Site replication time to " + site, rpcManager -> rpcManager.getAverageXSiteReplicationTimeTo(site), tags));
            attributes.add((MetricInfo)MetricUtils.createGauge("MinimumXSiteReplicationTimeTo_" + lSite, "Minimum Cross-Site replication time to " + site, rpcManager -> rpcManager.getMinimumXSiteReplicationTimeTo(site), tags));
            attributes.add((MetricInfo)MetricUtils.createGauge("MaximumXSiteReplicationTimeTo_" + lSite, "Maximum Cross-Site replication time to " + site, rpcManager -> rpcManager.getMaximumXSiteReplicationTimeTo(site), tags));
            attributes.add((MetricInfo)MetricUtils.createGauge("NumberXSiteRequestsSentTo_" + lSite, "Number of Cross-Site request sent to " + site, rpcManager -> rpcManager.getNumberXSiteRequestsSentTo(site), tags));
            attributes.add((MetricInfo)MetricUtils.createGauge("NumberXSiteRequestsReceivedFrom_" + lSite, "Number of Cross-Site request received from " + site, rpcManager -> rpcManager.getNumberXSiteRequestsReceivedFrom(site), tags));
            if (histograms) {
                attributes.add((MetricInfo)MetricUtils.createTimer("ReplicationTimesTo_" + lSite, "Replication times to " + site, (rpcManager, timer) -> rpcManager.xSiteMetricsCollector.registerTimer(site, (TimerTracker)timer), tags));
                continue;
            }
            attributes.add((MetricInfo)MetricUtils.createFunctionTimer("ReplicationTimesTo_" + lSite, "Replication times to " + site, (rpcManager, timer) -> rpcManager.xSiteMetricsCollector.registerTimer(site, (TimerTracker)timer), tags));
        }
        return attributes;
    }

    @Start(priority=9)
    void start() {
        this.statisticsEnabled = this.configuration.statistics().enabled();
        this.configuration.clustering().attributes().attribute(ClusteringConfiguration.REMOTE_TIMEOUT).addListener(this.updateRpcOptions);
        this.updateRpcOptions((Attribute<Long>)this.configuration.clustering().attributes().attribute(ClusteringConfiguration.REMOTE_TIMEOUT), null);
    }

    @Stop
    void stop() {
        this.configuration.clustering().attributes().attribute(ClusteringConfiguration.REMOTE_TIMEOUT).removeListener(this.updateRpcOptions);
    }

    private void updateRpcOptions(Attribute<Long> attribute, Long oldValue) {
        this.syncRpcOptions = new RpcOptions(DeliverOrder.NONE, (Long)attribute.get(), TimeUnit.MILLISECONDS);
    }

    @ManagedAttribute(description="Retrieves the committed view.", displayName="Committed view", dataType=DataType.TRAIT)
    public String getCommittedViewAsString() {
        LocalizedCacheTopology cacheTopology = this.distributionManager.getCacheTopology();
        if (cacheTopology == null) {
            return "N/A";
        }
        return cacheTopology.getCurrentCH().getMembers().toString();
    }

    @ManagedAttribute(description="Retrieves the pending view.", displayName="Pending view", dataType=DataType.TRAIT)
    public String getPendingViewAsString() {
        LocalizedCacheTopology cacheTopology = this.distributionManager.getCacheTopology();
        if (cacheTopology == null) {
            return "N/A";
        }
        ConsistentHash pendingCH = cacheTopology.getPendingCH();
        return pendingCH != null ? pendingCH.getMembers().toString() : "null";
    }

    @Override
    public <T> CompletionStage<T> invokeCommand(Address target, ReplicableCommand command, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        CompletionStage<Object> invocation;
        CacheRpcCommand cacheRpc = this.toCacheRpcCommand(command);
        if (!this.statisticsEnabled) {
            return this.t.invokeCommand(target, (ReplicableCommand)cacheRpc, collector, rpcOptions.deliverOrder(), rpcOptions.timeout(), rpcOptions.timeUnit());
        }
        long startTimeNanos = this.timeService.time();
        try {
            invocation = this.t.invokeCommand(target, (ReplicableCommand)cacheRpc, collector, rpcOptions.deliverOrder(), rpcOptions.timeout(), rpcOptions.timeUnit());
        }
        catch (Exception e) {
            return (CompletionStage)this.errorReplicating(e);
        }
        return invocation.handle((response, throwable) -> this.updateStatistics(startTimeNanos, (Object)response, (Throwable)throwable));
    }

    private void checkTopologyId(ReplicableCommand command) {
        if (command instanceof TopologyAffectedCommand && ((TopologyAffectedCommand)command).getTopologyId() < 0) {
            throw new IllegalArgumentException("Command does not have a topology id");
        }
    }

    @Override
    public <T> CompletionStage<T> invokeCommand(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        CompletionStage<Object> invocation;
        CacheRpcCommand cacheRpc = this.toCacheRpcCommand(command);
        if (!this.statisticsEnabled) {
            return this.t.invokeCommand(targets, (ReplicableCommand)cacheRpc, collector, rpcOptions.deliverOrder(), rpcOptions.timeout(), rpcOptions.timeUnit());
        }
        long startTimeNanos = this.timeService.time();
        try {
            invocation = this.t.invokeCommand(targets, (ReplicableCommand)cacheRpc, collector, rpcOptions.deliverOrder(), rpcOptions.timeout(), rpcOptions.timeUnit());
        }
        catch (Exception e) {
            return (CompletionStage)this.errorReplicating(e);
        }
        return invocation.handle((response, throwable) -> this.updateStatistics(startTimeNanos, (Object)response, (Throwable)throwable));
    }

    private <T> T updateStatistics(long startTimeNanos, T response, Throwable throwable) {
        long timeTaken = this.timeService.timeDuration(startTimeNanos, TimeUnit.MILLISECONDS);
        this.totalReplicationTime.add(timeTaken);
        if (throwable == null) {
            if (this.statisticsEnabled) {
                this.replicationCount.increment();
            }
            return response;
        }
        if (this.statisticsEnabled) {
            this.replicationFailures.increment();
        }
        return this.rethrowAsCacheException(throwable);
    }

    @Override
    public <T> CompletionStage<T> invokeCommandOnAll(ReplicableCommand command, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        CompletionStage<Object> invocation;
        CacheRpcCommand cacheRpc = this.toCacheRpcCommand(command);
        List<Address> cacheMembers = this.distributionManager.getCacheTopology().getMembers();
        if (!this.statisticsEnabled) {
            return this.t.invokeCommandOnAll(cacheMembers, cacheRpc, collector, rpcOptions.deliverOrder(), rpcOptions.timeout(), rpcOptions.timeUnit());
        }
        long startTimeNanos = this.timeService.time();
        try {
            invocation = this.t.invokeCommandOnAll(cacheMembers, cacheRpc, collector, rpcOptions.deliverOrder(), rpcOptions.timeout(), rpcOptions.timeUnit());
        }
        catch (Exception e) {
            return (CompletionStage)this.errorReplicating(e);
        }
        return invocation.handle((response, throwable) -> this.updateStatistics(startTimeNanos, (Object)response, (Throwable)throwable));
    }

    @Override
    public <T> CompletionStage<T> invokeCommandStaggered(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        CompletionStage<Object> invocation;
        CacheRpcCommand cacheRpc = this.toCacheRpcCommand(command);
        if (!this.statisticsEnabled) {
            return this.t.invokeCommandStaggered(targets, cacheRpc, collector, rpcOptions.deliverOrder(), rpcOptions.timeout(), rpcOptions.timeUnit());
        }
        long startTimeNanos = this.timeService.time();
        try {
            invocation = this.t.invokeCommandStaggered(targets, cacheRpc, collector, rpcOptions.deliverOrder(), rpcOptions.timeout(), rpcOptions.timeUnit());
        }
        catch (Exception e) {
            return (CompletionStage)this.errorReplicating(e);
        }
        return invocation.handle((response, throwable) -> this.updateStatistics(startTimeNanos, (Object)response, (Throwable)throwable));
    }

    @Override
    public <T> CompletionStage<T> invokeCommands(Collection<Address> targets, Function<Address, ReplicableCommand> commandGenerator, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        CompletionStage<Object> invocation;
        if (!this.statisticsEnabled) {
            return this.t.invokeCommands(targets, commandGenerator.andThen(this.toCacheRpcCommand), collector, rpcOptions.deliverOrder(), rpcOptions.timeout(), rpcOptions.timeUnit());
        }
        long startTimeNanos = this.timeService.time();
        try {
            invocation = this.t.invokeCommands(targets, commandGenerator.andThen(this.toCacheRpcCommand), collector, rpcOptions.deliverOrder(), rpcOptions.timeout(), rpcOptions.timeUnit());
        }
        catch (Exception e) {
            return (CompletionStage)this.errorReplicating(e);
        }
        return invocation.handle((response, throwable) -> this.updateStatistics(startTimeNanos, (Object)response, (Throwable)throwable));
    }

    @Override
    public <T> T blocking(CompletionStage<T> request) {
        try {
            return (T)CompletableFutures.await(request.toCompletableFuture());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException("Thread interrupted while invoking RPC", (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            cause.addSuppressed((Throwable)new TraceException());
            if (cause instanceof CacheException) {
                throw (CacheException)cause;
            }
            throw new CacheException("Unexpected exception replicating command", cause);
        }
    }

    @Override
    public CompletableFuture<Map<Address, Response>> invokeRemotelyAsync(Collection<Address> recipients, ReplicableCommand rpc, RpcOptions options) {
        CompletableFuture<Map<Address, Response>> invocation;
        this.setTopologyId(rpc);
        CacheRpcCommand cacheRpc = this.toCacheRpcCommand(rpc);
        long startTimeNanos = this.statisticsEnabled ? this.timeService.time() : 0L;
        try {
            invocation = this.t.invokeRemotelyAsync(recipients, cacheRpc, ResponseMode.SYNCHRONOUS, options.timeUnit().toMillis(options.timeout()), null, options.deliverOrder(), this.configuration.clustering().cacheMode().isDistributed());
        }
        catch (Exception e) {
            Log.CLUSTER.unexpectedErrorReplicating(e);
            if (this.statisticsEnabled) {
                this.replicationFailures.increment();
            }
            return (CompletableFuture)this.rethrowAsCacheException(e);
        }
        return invocation.whenComplete((responseMap, throwable) -> {
            if (this.statisticsEnabled) {
                this.updateStatistics(startTimeNanos, (Object)responseMap, (Throwable)throwable);
            }
        });
    }

    private <T> T rethrowAsCacheException(Throwable throwable) {
        if (throwable.getCause() != null && throwable instanceof CompletionException) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof CacheException) {
            log.trace("Replication exception", throwable);
            throw (CacheException)throwable;
        }
        Log.CLUSTER.unexpectedErrorReplicating(throwable);
        throw new CacheException(throwable);
    }

    private CacheRpcCommand toCacheRpcCommand(ReplicableCommand command) {
        this.checkTopologyId(command);
        return command instanceof CacheRpcCommand ? (CacheRpcCommand)command : this.cf.wired().buildSingleRpcCommand((VisitableCommand)command);
    }

    @Override
    public void sendTo(Address destination, ReplicableCommand command, DeliverOrder deliverOrder) {
        this.setTopologyId(command);
        CacheRpcCommand cacheRpc = this.toCacheRpcCommand(command);
        try {
            this.t.sendTo(destination, cacheRpc, deliverOrder);
        }
        catch (Exception e) {
            this.errorReplicating(e);
        }
    }

    @Override
    public void sendToMany(Collection<Address> destinations, ReplicableCommand command, DeliverOrder deliverOrder) {
        this.setTopologyId(command);
        CacheRpcCommand cacheRpc = this.toCacheRpcCommand(command);
        try {
            this.t.sendToMany(destinations, cacheRpc, deliverOrder);
        }
        catch (Exception e) {
            this.errorReplicating(e);
        }
    }

    @Override
    public void sendToAll(ReplicableCommand command, DeliverOrder deliverOrder) {
        this.setTopologyId(command);
        CacheRpcCommand cacheRpc = this.toCacheRpcCommand(command);
        try {
            this.t.sendToAll(cacheRpc, deliverOrder);
        }
        catch (Exception e) {
            this.errorReplicating(e);
        }
    }

    @Override
    public <O> XSiteResponse<O> invokeXSite(XSiteBackup backup, XSiteCacheRequest<O> command) {
        if (!this.statisticsEnabled) {
            return this.t.backupRemotely(backup, command);
        }
        XSiteResponse<O> rsp = this.t.backupRemotely(backup, command);
        rsp.whenCompleted(this.xSiteResponseCompleted);
        return rsp;
    }

    private void registerXSiteTime(XSiteBackup backup, long sentTimestamp, long durationNanos, Throwable ignored) {
        if (durationNanos <= 0L) {
            return;
        }
        this.xSiteMetricsCollector.recordRequestSent(backup.getSiteName(), durationNanos, TimeUnit.NANOSECONDS);
    }

    private <T> T errorReplicating(Throwable t) {
        Log.CLUSTER.unexpectedErrorReplicating(t);
        if (this.statisticsEnabled) {
            this.replicationFailures.increment();
        }
        return this.rethrowAsCacheException(t);
    }

    @Override
    public Transport getTransport() {
        return this.t;
    }

    private void setTopologyId(ReplicableCommand command) {
        TopologyAffectedCommand topologyAffectedCommand;
        if (command instanceof TopologyAffectedCommand && (topologyAffectedCommand = (TopologyAffectedCommand)command).getTopologyId() == -1) {
            int currentTopologyId = this.distributionManager.getCacheTopology().getTopologyId();
            if (log.isTraceEnabled()) {
                log.tracef("Topology id missing on command %s, setting it to %d", command, currentTopologyId);
            }
            topologyAffectedCommand.setTopologyId(currentTopologyId);
        }
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset statistics")
    public void resetStatistics() {
        this.replicationCount.reset();
        this.replicationFailures.reset();
        this.totalReplicationTime.reset();
        this.xSiteMetricsCollector.resetRequestsSent();
        this.xSiteMetricsCollector.resetRequestReceived();
    }

    @ManagedAttribute(description="Number of successful replications", displayName="Number of successful replications", measurementType=MeasurementType.TRENDSUP)
    public long getReplicationCount() {
        return this.isStatisticsEnabled() ? this.replicationCount.sum() : -1L;
    }

    @ManagedAttribute(description="Number of failed replications", displayName="Number of failed replications", measurementType=MeasurementType.TRENDSUP)
    public long getReplicationFailures() {
        return this.isStatisticsEnabled() ? this.replicationFailures.sum() : -1L;
    }

    @ManagedAttribute(description="Enables or disables the gathering of statistics by this component", displayName="Statistics enabled", dataType=DataType.TRAIT, writable=true)
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.isStatisticsEnabled();
    }

    @Override
    @Deprecated(forRemoval=true)
    @ManagedOperation(displayName="Enable/disable statistics. Deprecated, use the statisticsEnabled attribute instead.")
    public void setStatisticsEnabled(@Parameter(name="enabled", description="Whether statistics should be enabled or disabled (true/false)") boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    @ManagedAttribute(description="Successful replications as a ratio of total replications", displayName="Successful replications ratio")
    public String getSuccessRatio() {
        double ration;
        if (this.isStatisticsEnabled() && (ration = this.calculateSuccessRatio()) != 0.0) {
            return NumberFormat.getInstance().format(ration * 100.0) + "%";
        }
        return "N/A";
    }

    @ManagedAttribute(description="Successful replications as a ratio of total replications in numeric double format", displayName="Successful replication ratio", units=Units.PERCENTAGE)
    public double getSuccessRatioFloatingPoint() {
        return this.isStatisticsEnabled() ? this.calculateSuccessRatio() : 0.0;
    }

    private double calculateSuccessRatio() {
        double totalCount = this.replicationCount.sum() + this.replicationFailures.sum();
        return totalCount == 0.0 ? 0.0 : (double)this.replicationCount.sum() / totalCount;
    }

    @ManagedAttribute(description="The average time spent in the transport layer, in milliseconds", displayName="Average time spent in the transport layer", units=Units.MILLISECONDS)
    public long getAverageReplicationTime() {
        long count = this.replicationCount.sum();
        return this.isStatisticsEnabled() && count != 0L ? this.totalReplicationTime.sum() / count : 0L;
    }

    @ManagedAttribute(description="Retrieves the x-site view.", displayName="Cross site (x-site) view", dataType=DataType.TRAIT)
    public String getSitesView() {
        Set<String> sitesView = this.t.getSitesView();
        return sitesView != null ? sitesView.toString() : "N/A";
    }

    @ManagedAttribute(description="Returns the average replication time, in milliseconds, for a cross-site replication request", displayName="Average Cross-Site replication time", units=Units.MILLISECONDS)
    public long getAverageXSiteReplicationTime() {
        return this.isStatisticsEnabled() ? this.xSiteMetricsCollector.getAvgRequestSentDuration(-1L, TimeUnit.MILLISECONDS) : -1L;
    }

    @ManagedOperation(description="Returns the average replication time, in milliseconds, for cross-site request sent to the remote site.", displayName="Average Cross-Site replication time to Site", name="AverageXSiteReplicationTimeTo")
    public long getAverageXSiteReplicationTimeTo(@Parameter(name="dstSite", description="Destination site name") String dstSite) {
        return this.isStatisticsEnabled() ? this.xSiteMetricsCollector.getAvgRequestSentDuration(dstSite, -1L, TimeUnit.MILLISECONDS) : -1L;
    }

    @ManagedAttribute(description="Returns the minimum replication time, in milliseconds, for a cross-site replication request", displayName="Minimum Cross-Site replication time", units=Units.MILLISECONDS, measurementType=MeasurementType.TRENDSDOWN)
    public long getMinimumXSiteReplicationTime() {
        return this.isStatisticsEnabled() ? this.xSiteMetricsCollector.getMinRequestSentDuration(-1L, TimeUnit.MILLISECONDS) : -1L;
    }

    @ManagedOperation(description="Returns the minimum replication time, in milliseconds, for cross-site request sent to the remote site.", displayName="Minimum Cross-Site replication time to Site", name="MinimumXSiteReplicationTimeTo")
    public long getMinimumXSiteReplicationTimeTo(@Parameter(name="dstSite", description="Destination site name") String dstSite) {
        return this.isStatisticsEnabled() ? this.xSiteMetricsCollector.getMinRequestSentDuration(dstSite, -1L, TimeUnit.MILLISECONDS) : -1L;
    }

    @ManagedAttribute(description="Returns the maximum replication time, in milliseconds, for a cross-site replication request", displayName="Maximum Cross-Site replication time", units=Units.MILLISECONDS, measurementType=MeasurementType.TRENDSUP)
    public long getMaximumXSiteReplicationTime() {
        return this.isStatisticsEnabled() ? this.xSiteMetricsCollector.getMaxRequestSentDuration(-1L, TimeUnit.MILLISECONDS) : -1L;
    }

    @ManagedOperation(description="Returns the maximum replication time, in milliseconds, for cross-site request sent to the remote site.", displayName="Maximum Cross-Site replication time to Site", name="MaximumXSiteReplicationTimeTo")
    public long getMaximumXSiteReplicationTimeTo(@Parameter(name="dstSite", description="Destination site name") String dstSite) {
        return this.isStatisticsEnabled() ? this.xSiteMetricsCollector.getMaxRequestSentDuration(dstSite, -1L, TimeUnit.MILLISECONDS) : -1L;
    }

    @ManagedAttribute(description="Returns the number of sync cross-site requests", displayName="Cross-Site replication requests", measurementType=MeasurementType.TRENDSUP)
    public long getNumberXSiteRequests() {
        return this.isStatisticsEnabled() ? this.xSiteMetricsCollector.countRequestsSent() : 0L;
    }

    @ManagedOperation(description="Returns the number of cross-site requests sent to the remote site.", displayName="Number of Cross-Site request sent to site", name="NumberXSiteRequestsSentTo")
    public long getNumberXSiteRequestsSentTo(@Parameter(name="dstSite", description="Destination site name") String dstSite) {
        return this.isStatisticsEnabled() ? this.xSiteMetricsCollector.countRequestsSent(dstSite) : 0L;
    }

    @ManagedAttribute(description="Returns the number of cross-site requests received from all nodes", displayName="Number of Cross-Site Requests Received from all sites", measurementType=MeasurementType.TRENDSUP)
    public long getNumberXSiteRequestsReceived() {
        return this.isStatisticsEnabled() ? this.xSiteMetricsCollector.countRequestsReceived() : 0L;
    }

    @ManagedOperation(description="Returns the number of cross-site requests received from the remote site.", displayName="Number of Cross-Site request received from site", name="NumberXSiteRequestsReceivedFrom")
    public long getNumberXSiteRequestsReceivedFrom(@Parameter(name="srcSite", description="Originator site name") String srcSite) {
        return this.isStatisticsEnabled() ? this.xSiteMetricsCollector.countRequestsReceived(srcSite) : 0L;
    }

    public void setTransport(Transport t) {
        this.t = t;
    }

    @Override
    public Address getAddress() {
        return this.t != null ? this.t.getAddress() : null;
    }

    @Override
    public int getTopologyId() {
        LocalizedCacheTopology cacheTopology = this.distributionManager.getCacheTopology();
        return cacheTopology != null ? cacheTopology.getTopologyId() : -1;
    }

    @Override
    public RpcOptions getSyncRpcOptions() {
        return this.syncRpcOptions;
    }

    @Override
    public List<Address> getMembers() {
        return this.distributionManager.getCacheTopology().getMembers();
    }
}

