/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.opentelemetry.api;

import io.smallrye.opentelemetry.api.OpenTelemetryConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;

public final class WildFlyOpenTelemetryConfig
implements OpenTelemetryConfig {
    public static final boolean IS_WILDFLY_PREVIEW;
    public static NullaryServiceDescriptor<WildFlyOpenTelemetryConfig> SERVICE_DESCRIPTOR;
    public static final String OTEL_BSP_MAX_EXPORT_BATCH_SIZE = "otel.bsp.max.export.batch.size";
    public static final String OTEL_BSP_MAX_QUEUE_SIZE = "otel.bsp.max.queue.size";
    public static final String OTEL_BSP_SCHEDULE_DELAY = "otel.bsp.schedule.delay";
    public static final String OTEL_EXPORTER_OTLP_ENDPOINT = "otel.exporter.otlp.endpoint";
    public static final String OTEL_EXPORTER_OTLP_PROTOCOL = "otel.exporter.otlp.protocol";
    public static final String OTEL_EXPORTER_OTLP_TIMEOUT = "otel.exporter.otlp.timeout";
    public static final String OTEL_EXPORTER_OTLP_TRACES_PROTOCOL = "otel.exporter.otlp.traces.protocol";
    public static final String OTEL_LOGS_EXPORTER = "otel.logs.exporter";
    public static final String OTEL_PROPAGATORS = "otel.propagators";
    public static final String OTEL_METRICS_EXPORTER = "otel.metrics.exporter";
    public static final String OTEL_SDK_DISABLED = "otel.sdk.disabled";
    public static final String OTEL_SERVICE_NAME = "otel.service.name";
    public static final String OTEL_TRACES_EXPORTER = "otel.traces.exporter";
    public static final String OTEL_TRACES_SAMPLER = "otel.traces.sampler";
    public static final String OTEL_TRACES_SAMPLER_ARG = "otel.traces.sampler.arg";
    private final Map<String, String> properties;
    private final boolean mpTelemetryInstalled;

    public WildFlyOpenTelemetryConfig(Map<String, String> properties, boolean mpTelemetryInstalled) {
        this.properties = Collections.unmodifiableMap(properties);
        this.mpTelemetryInstalled = mpTelemetryInstalled;
    }

    public WildFlyOpenTelemetryConfig(String serviceName, String exporter, String endpoint, Long batchDelay, Long maxQueueSize, Long maxExportBatchSize, Long exportTimeout, String spanProcessorType, String sampler, Double ratio, boolean mpTelemetryInstalled) {
        HashMap<String, String> config = new HashMap<String, String>();
        this.addValue(config, OTEL_SDK_DISABLED, "false");
        this.addValue(config, OTEL_SERVICE_NAME, serviceName);
        this.addValue(config, OTEL_TRACES_EXPORTER, exporter);
        this.addValue(config, OTEL_PROPAGATORS, "tracecontext,baggage");
        if (IS_WILDFLY_PREVIEW) {
            this.addValue(config, OTEL_LOGS_EXPORTER, exporter);
            this.addValue(config, OTEL_METRICS_EXPORTER, exporter);
        } else {
            this.addValue(config, OTEL_LOGS_EXPORTER, "none");
            this.addValue(config, OTEL_METRICS_EXPORTER, "none");
        }
        if (!exporter.equals("otlp")) {
            throw new IllegalArgumentException("An unexpected exporter type was found: " + exporter);
        }
        this.addValue(config, OTEL_EXPORTER_OTLP_ENDPOINT, endpoint);
        this.addValue(config, OTEL_EXPORTER_OTLP_PROTOCOL, "grpc");
        this.addValue(config, OTEL_EXPORTER_OTLP_TIMEOUT, exportTimeout);
        this.addValue(config, "otel.metric.export.interval", batchDelay);
        this.addValue(config, OTEL_BSP_SCHEDULE_DELAY, batchDelay);
        this.addValue(config, OTEL_BSP_MAX_QUEUE_SIZE, maxQueueSize);
        this.addValue(config, OTEL_BSP_MAX_EXPORT_BATCH_SIZE, maxExportBatchSize);
        if (sampler != null) {
            switch (sampler) {
                case "on": {
                    this.addValue(config, OTEL_TRACES_SAMPLER, "always_on");
                    break;
                }
                case "off": {
                    this.addValue(config, OTEL_TRACES_SAMPLER, "always_off");
                    break;
                }
                case "ratio": {
                    this.addValue(config, OTEL_TRACES_SAMPLER, "traceidratio");
                    this.addValue(config, OTEL_TRACES_SAMPLER_ARG, ratio);
                }
            }
        }
        this.properties = Collections.unmodifiableMap(config);
        this.mpTelemetryInstalled = mpTelemetryInstalled;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public boolean isMpTelemetryInstalled() {
        return this.mpTelemetryInstalled;
    }

    private void addValue(Map<String, String> config, String key, Object value) {
        if (value != null) {
            config.put(key, value.toString());
        }
    }

    static {
        boolean classFound = false;
        try {
            Class.forName("io.smallrye.opentelemetry.implementation.exporters.metrics.VertxMetricsExporterProvider");
            classFound = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        IS_WILDFLY_PREVIEW = classFound;
        SERVICE_DESCRIPTOR = NullaryServiceDescriptor.of((String)"org.wildfly.extension.opentelemetry.config", WildFlyOpenTelemetryConfig.class);
    }
}

