/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;

public interface Formatter<T> {
    public static final Identity IDENTITY = new Identity(){

        @Override
        public Class<String> getType() {
            return String.class;
        }

        @Override
        public String parse(String value) {
            return value;
        }

        @Override
        public String format(String key) {
            return key;
        }
    };

    public Class<? extends T> getType();

    public T parse(String var1);

    public String format(T var1);

    default public <U> Formatter<U> wrap(final Class<? extends U> type, final Function<U, T> unwrapper, final Function<T, U> wrapper) {
        final Formatter formatter = this;
        return new Formatter<U>(this){
            final /* synthetic */ Formatter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Class<? extends U> getType() {
                return type;
            }

            @Override
            public U parse(String value) {
                return wrapper.apply(formatter.parse(value));
            }

            @Override
            public String format(U value) {
                return formatter.format(unwrapper.apply(value));
            }
        };
    }

    public static <T> Formatter<T> of(final T value) {
        return new Formatter<T>(){

            @Override
            public Class<T> getType() {
                return value.getClass();
            }

            @Override
            public T parse(String ignored) {
                return value;
            }

            @Override
            public String format(T ignored) {
                return "";
            }
        };
    }

    public static <T, V1, V2> Formatter<T> joining(final Class<? extends T> type, final String delimiter, final Formatter<V1> formatter1, final Formatter<V2> formatter2, final Function<T, V1> unwrapper1, final Function<T, V2> unwrapper2, final BiFunction<V1, V2, T> wrapper) {
        return new Formatter<T>(){

            @Override
            public Class<? extends T> getType() {
                return type;
            }

            @Override
            public T parse(String value) {
                String[] values = value.split(Pattern.quote(delimiter));
                return wrapper.apply(formatter1.parse(values[0]), formatter2.parse(values[1]));
            }

            @Override
            public String format(T value) {
                return String.join((CharSequence)delimiter, formatter1.format(unwrapper1.apply(value)), formatter2.format(unwrapper2.apply(value)));
            }
        };
    }

    public static <T> Formatter<T> joining(final Class<? extends T> type, final String delimiter, final Function<T, String[]> unwrapper, final Function<String[], T> wrapper) {
        return new Formatter<T>(){

            @Override
            public Class<? extends T> getType() {
                return type;
            }

            @Override
            public T parse(String value) {
                return wrapper.apply(value.split(Pattern.quote(delimiter)));
            }

            @Override
            public String format(T value) {
                return String.join((CharSequence)delimiter, (CharSequence[])unwrapper.apply(value));
            }
        };
    }

    public static interface Identity
    extends Formatter<String> {
        default public <U> Formatter<U> wrap(Class<U> targetClass, Function<String, U> wrapper) {
            return this.wrap(targetClass, Object::toString, wrapper);
        }
    }

    public static class Provided<T>
    implements Formatter<T> {
        private final Formatter<T> formatter;

        public Provided(Formatter<T> formatter) {
            this.formatter = formatter;
        }

        @Override
        public Class<? extends T> getType() {
            return this.formatter.getType();
        }

        @Override
        public T parse(String value) {
            return this.formatter.parse(value);
        }

        @Override
        public String format(T value) {
            return this.formatter.format(value);
        }

        @Override
        public <U> Formatter<U> wrap(Class<? extends U> type, Function<U, T> unwrapper, Function<T, U> wrapper) {
            return this.formatter.wrap(type, unwrapper, wrapper);
        }
    }
}

