/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.keystore;

import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.wildfly.security.keystore.DelegatingKeyStoreSpi;
import org.wildfly.security.keystore.ElytronMessages;

class FilteringKeyStoreSpi
extends DelegatingKeyStoreSpi {
    private final KeyStore keyStore;
    private final Predicate<String> aliasPredicate;
    private boolean loaded = false;

    FilteringKeyStoreSpi(KeyStore keyStore, Predicate<String> aliasPredicate) {
        this.keyStore = keyStore;
        this.aliasPredicate = aliasPredicate;
        ElytronMessages.tls.tracef("FilteringKeyStore initialization:  keyStore = %s,  aliasPredicate = %s", keyStore, aliasPredicate);
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.aliasPredicate.test(alias) ? super.engineGetKey(alias, password) : null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        return this.aliasPredicate.test(alias) ? super.engineGetCertificateChain(alias) : null;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        return this.aliasPredicate.test(alias) ? super.engineGetCertificate(alias) : null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        return this.aliasPredicate.test(alias) ? super.engineGetCreationDate(alias) : null;
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.aliasPredicate.test(alias) ? super.engineContainsAlias(alias) : false;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return this.aliasPredicate.test(alias) ? super.engineIsKeyEntry(alias) : false;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return this.aliasPredicate.test(alias) ? super.engineIsCertificateEntry(alias) : false;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        String alias = super.engineGetCertificateAlias(cert);
        return alias != null ? (this.aliasPredicate.test(alias) ? alias : null) : null;
    }

    private Stream<String> aliasStream() {
        return Collections.list(super.engineAliases()).stream().filter(this.aliasPredicate);
    }

    @Override
    public Enumeration<String> engineAliases() {
        return Collections.enumeration(this.aliasStream().collect(Collectors.toList()));
    }

    @Override
    public int engineSize() {
        return this.aliasStream().mapToInt(s -> 1).sum();
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (this.loaded) {
            throw new UnsupportedOperationException();
        }
        this.loaded = true;
    }

    @Override
    protected KeyStore getKeyStore() {
        return this.keyStore;
    }
}

