/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public enum InetAddressMarshaller implements FieldSetMarshaller.Simple<InetAddress>
{
    INSTANCE;

    private static final InetAddress DEFAULT;
    private static final int HOST_NAME_INDEX = 0;
    private static final int ADDRESS_INDEX = 1;
    private static final int FIELDS = 2;

    @Override
    public InetAddress createInitialValue() {
        return DEFAULT;
    }

    @Override
    public int getFields() {
        return 2;
    }

    @Override
    public InetAddress readFrom(ProtoStreamReader reader, int index, WireType type, InetAddress address) throws IOException {
        switch (index) {
            case 0: {
                final String hostName = reader.readString();
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<InetAddress>(this){
                        final /* synthetic */ InetAddressMarshaller this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public InetAddress run() throws UnknownHostException {
                            return InetAddress.getByName(hostName);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception exception = e.getException();
                    if (exception instanceof IOException) {
                        throw (IOException)exception;
                    }
                    throw new IllegalStateException(e);
                }
            }
            case 1: {
                return InetAddress.getByAddress(reader.readByteArray());
            }
        }
        reader.skipField(type);
        return address;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, InetAddress address) throws IOException {
        String hostName = InetAddressMarshaller.resolvedHostName(address);
        if (hostName != null) {
            if (!hostName.equals(DEFAULT.getHostName())) {
                writer.writeString(0, hostName);
            }
        } else {
            byte[] bytes = address.getAddress();
            if (!Arrays.equals(bytes, DEFAULT.getAddress())) {
                writer.writeBytes(1, address.getAddress());
            }
        }
    }

    private static String resolvedHostName(InetAddress address) {
        InetSocketAddress socketAddress = new InetSocketAddress(address, 0);
        return socketAddress.toString().lastIndexOf(47) > 0 ? socketAddress.getHostString() : null;
    }

    static {
        DEFAULT = InetAddress.getLoopbackAddress();
    }
}

