/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.runnables;

import java.util.HashSet;
import java.util.function.Consumer;
import org.apache.activemq.artemis.utils.runnables.AtomicRunnable;

public class RunnableList {
    private final HashSet<AtomicRunnable> list = new HashSet();

    public synchronized void add(AtomicRunnable runnable) {
        runnable.setAcceptedList(this);
        this.list.add(runnable);
    }

    public int size() {
        return this.list.size();
    }

    public synchronized void remove(AtomicRunnable runnable) {
        this.list.remove(runnable);
    }

    public synchronized void cancel() {
        this.list.forEach(this::cancel);
        this.list.clear();
    }

    private void cancel(AtomicRunnable atomicRunnable) {
        atomicRunnable.cancel();
    }

    public void forEach(Consumer<AtomicRunnable> consumerRunnable) {
        this.list.forEach(consumerRunnable);
    }
}

