/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.function.Consumer;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.undertow.AjpListenerResourceDefinition;
import org.wildfly.extension.undertow.AjpListenerService;
import org.wildfly.extension.undertow.ListenerAdd;
import org.wildfly.extension.undertow.ListenerResourceDefinition;
import org.wildfly.extension.undertow.ListenerService;
import org.xnio.OptionMap;

class AjpListenerAdd
extends ListenerAdd<AjpListenerService> {
    AjpListenerAdd() {
    }

    @Override
    AjpListenerService createService(Consumer<ListenerService> serviceConsumer, String name, String serverName, OperationContext context, ModelNode model, OptionMap listenerOptions, OptionMap socketOptions) throws OperationFailedException {
        ModelNode schemeNode = AjpListenerResourceDefinition.SCHEME.resolveModelAttribute(context, model);
        String scheme = null;
        if (schemeNode.isDefined()) {
            scheme = schemeNode.asString();
        }
        OptionMap.Builder listenerBuilder = OptionMap.builder().addAll(listenerOptions);
        AjpListenerResourceDefinition.MAX_AJP_PACKET_SIZE.resolveOption((ExpressionResolver)context, model, listenerBuilder);
        AjpListenerResourceDefinition.ALLOWED_REQUEST_ATTRIBUTES_PATTERN.resolveOption((ExpressionResolver)context, model, listenerBuilder);
        return new AjpListenerService(serviceConsumer, context.getCurrentAddress(), scheme, listenerBuilder.getMap(), socketOptions);
    }

    @Override
    void configureAdditionalDependencies(OperationContext context, CapabilityServiceBuilder<?> serviceBuilder, ModelNode model, AjpListenerService service) throws OperationFailedException {
        ModelNode redirectBindingRef = ListenerResourceDefinition.REDIRECT_SOCKET.resolveModelAttribute(context, model);
        if (redirectBindingRef.isDefined()) {
            service.getRedirectSocket().set(serviceBuilder.requires(SocketBinding.SERVICE_DESCRIPTOR, redirectBindingRef.asString()));
        }
    }
}

