/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Decorator;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.enterprise.inject.spi.ObserverMethod;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.enterprise.inject.spi.Prioritized;
import jakarta.enterprise.inject.spi.configurator.BeanConfigurator;
import jakarta.enterprise.inject.spi.configurator.ObserverMethodConfigurator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeStore;
import org.jboss.weld.bean.CustomDecoratorWrapper;
import org.jboss.weld.bean.WeldBean;
import org.jboss.weld.bean.attributes.ExternalBeanAttributesFactory;
import org.jboss.weld.bootstrap.BeanDeploymentArchiveMapping;
import org.jboss.weld.bootstrap.BeanDeploymentFinder;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.bootstrap.enablement.GlobalEnablementBuilder;
import org.jboss.weld.bootstrap.event.InterceptorConfigurator;
import org.jboss.weld.bootstrap.event.WeldAfterBeanDiscovery;
import org.jboss.weld.bootstrap.event.WeldBeanConfigurator;
import org.jboss.weld.bootstrap.events.AbstractBeanDiscoveryEvent;
import org.jboss.weld.bootstrap.events.ContainerLifecycleEvents;
import org.jboss.weld.bootstrap.events.InterceptorConfiguratorImpl;
import org.jboss.weld.bootstrap.events.configurator.BeanConfiguratorImpl;
import org.jboss.weld.bootstrap.events.configurator.ObserverMethodConfiguratorImpl;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.logging.ContextLogger;
import org.jboss.weld.logging.InterceptorLogger;
import org.jboss.weld.logging.MetadataLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Bindings;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.reflection.Reflections;

public class AfterBeanDiscoveryImpl
extends AbstractBeanDiscoveryEvent
implements WeldAfterBeanDiscovery {
    private static final String TYPE_ARGUMENT_NAME = "type";
    private final SlimAnnotatedTypeStore slimAnnotatedTypeStore;
    private final ContainerLifecycleEvents containerLifecycleEvents;
    private final List<BeanRegistration> additionalBeans;
    private final List<ObserverRegistration> additionalObservers;

    public static void fire(BeanManagerImpl beanManager, Deployment deployment, BeanDeploymentArchiveMapping bdaMapping, Collection<ContextHolder<? extends Context>> contexts) {
        AfterBeanDiscoveryImpl event = new AfterBeanDiscoveryImpl(beanManager, deployment, bdaMapping, contexts);
        event.fire();
        event.finish();
    }

    private AfterBeanDiscoveryImpl(BeanManagerImpl beanManager, Deployment deployment, BeanDeploymentArchiveMapping bdaMapping, Collection<ContextHolder<? extends Context>> contexts) {
        super(beanManager, (Type)((Object)WeldAfterBeanDiscovery.class), bdaMapping, deployment, contexts);
        this.slimAnnotatedTypeStore = (SlimAnnotatedTypeStore)beanManager.getServices().get(SlimAnnotatedTypeStore.class);
        this.containerLifecycleEvents = (ContainerLifecycleEvents)beanManager.getServices().get(ContainerLifecycleEvents.class);
        this.additionalBeans = new LinkedList<BeanRegistration>();
        this.additionalObservers = new LinkedList<ObserverRegistration>();
    }

    public void addBean(Bean<?> bean) {
        this.checkWithinObserverNotification();
        Preconditions.checkArgumentNotNull(bean, "bean");
        ExternalBeanAttributesFactory.validateBeanAttributes(bean, (BeanManager)this.getBeanManager());
        this.validateBean(bean);
        this.additionalBeans.add(BeanRegistration.of(bean, this.getReceiver()));
        BootstrapLogger.LOG.addBeanCalled(this.getReceiver(), bean);
    }

    public <T> WeldBeanConfigurator<T> addBean() {
        return this.addBean(this.getReceiver() != null ? this.getReceiver().getClass() : null, null);
    }

    public <T> WeldBeanConfigurator<T> addBean(Class<?> receiverClass, Class<?> fallbackClass) {
        this.checkWithinObserverNotification();
        BeanConfiguratorImpl configurator = new BeanConfiguratorImpl(receiverClass, fallbackClass, this.getBeanDeploymentFinder());
        this.additionalBeans.add(BeanRegistration.of(configurator, this.getReceiver()));
        return configurator;
    }

    public void addContext(Context context) {
        this.checkWithinObserverNotification();
        Preconditions.checkArgumentNotNull(context, "context");
        Class scope = context.getScope();
        if (scope == null) {
            throw ContextLogger.LOG.contextHasNullScope(context);
        }
        if (!this.getBeanManager().isScope(scope)) {
            MetadataLogger.LOG.contextGetScopeIsNotAScope(scope, context);
        }
        if (scope == ApplicationScoped.class || scope == Dependent.class) {
            throw ContextLogger.LOG.cannotRegisterContext(scope, context);
        }
        this.getBeanManager().addContext(context);
        BootstrapLogger.LOG.addContext(this.getReceiver(), context);
    }

    public void addObserverMethod(ObserverMethod<?> observerMethod) {
        this.checkWithinObserverNotification();
        Preconditions.checkArgumentNotNull(observerMethod, "observerMethod");
        Observers.validateObserverMethod(observerMethod, (BeanManager)this.getBeanManager(), null);
        this.additionalObservers.add(ObserverRegistration.of(observerMethod, this.getReceiver()));
        BootstrapLogger.LOG.addObserverMethodCalled(this.getReceiver(), observerMethod);
    }

    public <T> ObserverMethodConfigurator<T> addObserverMethod() {
        this.checkWithinObserverNotification();
        ObserverMethodConfiguratorImpl configurator = new ObserverMethodConfiguratorImpl(this.getReceiver());
        this.additionalObservers.add(ObserverRegistration.of(configurator, this.getReceiver()));
        return configurator;
    }

    public <T> AnnotatedType<T> getAnnotatedType(Class<T> type, String id) {
        this.checkWithinObserverNotification();
        Preconditions.checkArgumentNotNull(type, TYPE_ARGUMENT_NAME);
        return this.slimAnnotatedTypeStore.get(type, id);
    }

    public <T> Iterable<AnnotatedType<T>> getAnnotatedTypes(Class<T> type) {
        this.checkWithinObserverNotification();
        Preconditions.checkArgumentNotNull(type, TYPE_ARGUMENT_NAME);
        return (Iterable)Reflections.cast(this.slimAnnotatedTypeStore.get(type));
    }

    public InterceptorConfigurator addInterceptor() {
        InterceptorConfiguratorImpl configurator = new InterceptorConfiguratorImpl(this.getBeanManager());
        this.additionalBeans.add(BeanRegistration.of(configurator));
        return configurator;
    }

    private void finish() {
        try {
            GlobalEnablementBuilder globalEnablementBuilder = (GlobalEnablementBuilder)this.getBeanManager().getServices().get(GlobalEnablementBuilder.class);
            for (BeanRegistration beanRegistration : this.additionalBeans) {
                this.processBeanRegistration(beanRegistration, globalEnablementBuilder);
            }
            for (ObserverRegistration observerRegistration : this.additionalObservers) {
                this.processObserverRegistration(observerRegistration);
            }
        }
        catch (Exception e) {
            throw new DefinitionException((Throwable)e);
        }
    }

    private <T> void processBeanRegistration(BeanRegistration registration, GlobalEnablementBuilder globalEnablementBuilder) {
        Integer priority;
        Bean<?> bean = registration.initBean();
        BeanManagerImpl beanManager = registration.initBeanManager();
        if (beanManager == null) {
            beanManager = this.getOrCreateBeanDeployment(bean.getBeanClass()).getBeanManager();
        } else {
            ExternalBeanAttributesFactory.validateBeanAttributes(bean, (BeanManager)this.getBeanManager());
            this.validateBean(bean);
        }
        Integer n = priority = bean instanceof Prioritized ? Integer.valueOf(((Prioritized)bean).getPriority()) : null;
        if (priority == null && bean instanceof WeldBean) {
            priority = ((WeldBean)bean).getPriority();
        }
        if (bean instanceof Interceptor) {
            beanManager.addInterceptor((Interceptor)bean);
            if (priority != null) {
                globalEnablementBuilder.addInterceptor(bean.getBeanClass(), priority);
            }
        } else if (bean instanceof Decorator) {
            beanManager.addDecorator(CustomDecoratorWrapper.of((Decorator)bean, beanManager));
            if (priority != null) {
                globalEnablementBuilder.addDecorator(bean.getBeanClass(), priority);
            }
        } else {
            beanManager.addBean(bean);
            if (priority != null && bean.isAlternative()) {
                globalEnablementBuilder.addAlternative(bean.getBeanClass(), priority);
            }
        }
        this.containerLifecycleEvents.fireProcessBean(beanManager, bean, registration.extension);
    }

    private void validateBean(Bean<?> bean) {
        PassivationCapable passivationCapable;
        if (bean.getBeanClass() == null) {
            throw BeanLogger.LOG.beanMethodReturnsNull("getBeanClass", bean);
        }
        if (bean.getInjectionPoints() == null) {
            throw BeanLogger.LOG.beanMethodReturnsNull("getInjectionPoints", bean);
        }
        if (bean instanceof PassivationCapable && (passivationCapable = (PassivationCapable)bean).getId() == null) {
            throw BeanLogger.LOG.passivationCapableBeanHasNullId(bean);
        }
        if (bean instanceof Interceptor) {
            this.validateInterceptor((Interceptor)bean);
        } else if (bean instanceof Decorator) {
            this.validateDecorator((Decorator)bean);
        }
    }

    private void validateInterceptor(Interceptor<?> interceptor) {
        Set bindings = interceptor.getInterceptorBindings();
        if (bindings == null) {
            throw InterceptorLogger.LOG.nullInterceptorBindings(interceptor);
        }
        for (Annotation annotation : bindings) {
            if (this.getBeanManager().isInterceptorBinding(annotation.annotationType())) continue;
            throw MetadataLogger.LOG.notAnInterceptorBinding(annotation, interceptor);
        }
    }

    private void validateDecorator(Decorator<?> decorator) {
        Set qualifiers = decorator.getDelegateQualifiers();
        if (decorator.getDelegateType() == null) {
            throw BeanLogger.LOG.decoratorMethodReturnsNull("getDelegateType", decorator);
        }
        Bindings.validateQualifiers(qualifiers, (BeanManager)this.getBeanManager(), decorator, "Decorator.getDelegateQualifiers");
        if (decorator.getDecoratedTypes() == null) {
            throw BeanLogger.LOG.decoratorMethodReturnsNull("getDecoratedTypes", decorator);
        }
    }

    private void processObserverRegistration(ObserverRegistration registration) {
        ObserverMethod<?> processedObserver;
        ObserverMethod<?> observerMethod = registration.initObserverMethod();
        Observers.validateObserverMethod(observerMethod, (BeanManager)this.getBeanManager(), null);
        BeanManagerImpl manager = this.getOrCreateBeanDeployment(observerMethod.getBeanClass()).getBeanManager();
        if (Observers.isObserverMethodEnabled(observerMethod, manager) && (processedObserver = this.containerLifecycleEvents.fireProcessObserverMethod(manager, observerMethod, registration.extension)) != null) {
            manager.addObserver(processedObserver);
        }
    }

    private BeanDeploymentFinder getBeanDeploymentFinder() {
        return new BeanDeploymentFinder(this.getBeanDeployments(), this.getDeployment(), this.getContexts(), this.getBeanManager());
    }

    private static class ObserverRegistration {
        private final ObserverMethod<?> observerMethod;
        private final Extension extension;
        private final ObserverMethodConfiguratorImpl<?> observerMethodConfigurator;

        static ObserverRegistration of(ObserverMethod<?> observerMethod, Extension extension) {
            return new ObserverRegistration(observerMethod, null, extension);
        }

        static <T> ObserverRegistration of(ObserverMethodConfiguratorImpl<T> configurator, Extension extension) {
            return new ObserverRegistration(null, configurator, extension);
        }

        private ObserverRegistration(ObserverMethod<?> observerMethod, ObserverMethodConfiguratorImpl<?> observerMethodBuilder, Extension extension) {
            this.observerMethod = observerMethod;
            this.observerMethodConfigurator = observerMethodBuilder;
            this.extension = extension;
        }

        ObserverMethod<?> initObserverMethod() {
            if (this.observerMethod != null) {
                return this.observerMethod;
            }
            try {
                return this.observerMethodConfigurator.complete();
            }
            catch (Exception e) {
                throw BootstrapLogger.LOG.unableToProcessConfigurator(ObserverMethodConfigurator.class.getSimpleName(), this.extension, e);
            }
        }
    }

    private static class BeanRegistration {
        private final Bean<?> bean;
        private final BeanConfiguratorImpl<?> beanConfigurator;
        private final InterceptorConfiguratorImpl interceptorBuilder;
        private final Extension extension;

        static BeanRegistration of(Bean<?> bean, Extension extension) {
            return new BeanRegistration(bean, null, null, extension);
        }

        static BeanRegistration of(BeanConfiguratorImpl<?> configurator, Extension extension) {
            return new BeanRegistration(null, configurator, null, extension);
        }

        static BeanRegistration of(InterceptorConfiguratorImpl interceptorBuilder) {
            return new BeanRegistration(null, null, interceptorBuilder, null);
        }

        BeanRegistration(Bean<?> bean, BeanConfiguratorImpl<?> beanConfigurator, InterceptorConfiguratorImpl interceptorBuilder, Extension extension) {
            this.bean = bean;
            this.beanConfigurator = beanConfigurator;
            this.interceptorBuilder = interceptorBuilder;
            this.extension = extension;
        }

        public Bean<?> initBean() {
            if (this.bean != null) {
                return this.bean;
            }
            if (this.beanConfigurator != null) {
                Bean<?> bean;
                try {
                    bean = this.beanConfigurator.complete();
                }
                catch (Exception e) {
                    throw BootstrapLogger.LOG.unableToProcessConfigurator(BeanConfigurator.class.getSimpleName(), this.extension, e);
                }
                BootstrapLogger.LOG.addBeanCalled(this.extension, bean);
                return bean;
            }
            return this.interceptorBuilder.build();
        }

        protected BeanManagerImpl initBeanManager() {
            if (this.bean != null) {
                return null;
            }
            if (this.beanConfigurator != null) {
                return this.beanConfigurator.getBeanManager();
            }
            return this.interceptorBuilder.getBeanManager();
        }
    }
}

