/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.audit;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.audit.AuditLogHandler;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.audit.SyslogAuditLogHandler;
import org.jboss.as.controller.audit.SyslogCredentialReferenceSupplier;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.audit.AuditLogHandlerResourceDefinition;
import org.jboss.as.domain.management.audit.EnvironmentNameReader;
import org.jboss.as.domain.management.audit.HandlerUtil;
import org.jboss.as.domain.management.audit.SyslogAuditLogHandlerService;
import org.jboss.as.domain.management.audit.SyslogAuditLogProtocolResourceDefinition;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.logmanager.handlers.SyslogHandler;
import org.jboss.msc.service.ServiceName;

public class SyslogAuditLogHandlerResourceDefinition
extends AuditLogHandlerResourceDefinition {
    private final EnvironmentNameReader environmentReader;
    private static final String DEFAULT_APP_NAME_IF_NOT_A_PRODUCT = "WildFly";
    public static final SimpleAttributeDefinition SYSLOG_FORMAT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("syslog-format", ModelType.STRING).setRequired(false)).setDefaultValue(new ModelNode(SyslogHandler.SyslogType.RFC5424.toString()))).setAllowExpression(true)).setValidator((ParameterValidator)EnumValidator.create(SyslogHandler.SyslogType.class))).setMinSize(1)).build();
    public static final SimpleAttributeDefinition TRUNCATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("truncate", ModelType.BOOLEAN).setRequired(false)).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition MAX_LENGTH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-length", ModelType.INT).setRequired(false)).setAllowExpression(true)).setMinSize(0)).build();
    public static final SimpleAttributeDefinition FACILITY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("facility", ModelType.STRING).setRequired(false)).setValidator((ParameterValidator)EnumValidator.create(SyslogAuditLogHandler.Facility.class))).setDefaultValue(new ModelNode(SyslogAuditLogHandler.Facility.USER_LEVEL.name()))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition APP_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("app-name", ModelType.STRING).setRequired(false)).setAllowExpression(true)).build();
    private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{FORMATTER, MAX_LENGTH, SYSLOG_FORMAT, TRUNCATE, MAX_FAILURE_COUNT, APP_NAME, FACILITY};

    public SyslogAuditLogHandlerResourceDefinition(ManagedAuditLogger auditLogger, PathManagerService pathManager, EnvironmentNameReader environmentReader) {
        super(auditLogger, pathManager, new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"syslog-handler"), DomainManagementResolver.getDeprecatedResolver("core.management.audit-log", "core.management.syslog-handler")).setAddHandler((OperationStepHandler)new SyslogAuditLogHandlerAddHandler(auditLogger, pathManager, environmentReader)).setRemoveHandler((OperationStepHandler)new AuditLogHandlerResourceDefinition.HandlerRemoveHandler(auditLogger)));
        this.environmentReader = environmentReader;
        this.setDeprecated(ModelVersion.create((int)1, (int)7));
    }

    public static void createServerAddOperations(List<ModelNode> addOps, PathAddress syslogHandlerAddress, ModelNode syslogHandler) {
        ModelNode syslogHandlerAdd = SyslogAuditLogHandlerResourceDefinition.createServerAddOperation(syslogHandlerAddress, syslogHandler);
        addOps.add(syslogHandlerAdd);
        Property protocol = (Property)syslogHandler.get("protocol").asPropertyList().iterator().next();
        PathAddress protocolAddress = syslogHandlerAddress.append(new PathElement[]{PathElement.pathElement((String)"protocol", (String)protocol.getName())});
        SyslogAuditLogProtocolResourceDefinition.createServerAddOperations(addOps, protocolAddress, protocol.getValue());
    }

    public static ModelNode createServerAddOperation(PathAddress syslogHandlerAddress, ModelNode syslogHandler) {
        ModelNode syslogHandlerAdd = Util.createAddOperation((PathAddress)syslogHandlerAddress);
        for (AttributeDefinition def : ATTRIBUTES) {
            if (!syslogHandler.get(def.getName()).isDefined()) continue;
            syslogHandlerAdd.get(def.getName()).set(syslogHandler.get(def.getName()));
        }
        return syslogHandlerAdd;
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        HandlerWriteAttributeHandler writeAttribute = new HandlerWriteAttributeHandler(this.auditLogger, this.pathManager, this.environmentReader);
        for (AttributeDefinition def : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(def, null, (OperationStepHandler)writeAttribute);
        }
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)new SyslogAuditLogProtocolResourceDefinition.Udp(this.auditLogger, this.pathManager, this.environmentReader));
        resourceRegistration.registerSubModel((ResourceDefinition)new SyslogAuditLogProtocolResourceDefinition.Tcp(this.auditLogger, this.pathManager, this.environmentReader));
        resourceRegistration.registerSubModel((ResourceDefinition)new SyslogAuditLogProtocolResourceDefinition.Tls(this.auditLogger, this.pathManager, this.environmentReader));
    }

    static PathAddress getAffectedHandlerAddress(OperationContext context) {
        int lastElement;
        PathAddress opAddress = context.getCurrentAddress();
        for (int i = lastElement = opAddress.size() - 1; i > 0; --i) {
            PathElement element = opAddress.getElement(i);
            if (!element.getKey().equals("syslog-handler")) continue;
            return i == lastElement ? opAddress : opAddress.subAddress(0, i + 1);
        }
        return PathAddress.EMPTY_ADDRESS;
    }

    static SyslogAuditLogHandler createHandler(PathManagerService pathManager, OperationContext context, EnvironmentNameReader environmentReader) throws OperationFailedException {
        PathAddress pathAddress = SyslogAuditLogHandlerResourceDefinition.getAffectedHandlerAddress(context);
        String name = Util.getNameFromAddress((PathAddress)pathAddress);
        Resource handlerResource = context.readResourceFromRoot(pathAddress);
        return SyslogAuditLogHandlerResourceDefinition.createHandler(pathManager, context, name, handlerResource, environmentReader);
    }

    static SyslogAuditLogHandler createHandler(PathManagerService pathManager, OperationContext context, String name, Resource handlerResource, EnvironmentNameReader environmentReader) throws OperationFailedException {
        Set protocols;
        ServiceName serviceName = SyslogAuditLogHandlerService.SYSLOG_AUDIT_HANDLER.append(new String[]{name});
        if (context.getServiceRegistry(true).getService(serviceName) != null) {
            context.removeService(serviceName);
        }
        SyslogAuditLogHandlerService service = SyslogAuditLogHandlerService.installService(context, serviceName, handlerResource);
        ModelNode handlerModel = handlerResource.getModel();
        String formatterName = FORMATTER.resolveModelAttribute(context, handlerModel).asString();
        int maxFailureCount = MAX_FAILURE_COUNT.resolveModelAttribute(context, handlerModel).asInt();
        SyslogAuditLogHandler handler = new SyslogAuditLogHandler(name, formatterName, maxFailureCount, pathManager, (SyslogCredentialReferenceSupplier)service);
        handler.setFacility(SyslogAuditLogHandler.Facility.valueOf((String)FACILITY.resolveModelAttribute(context, handlerModel).asString()));
        if (environmentReader.isServer()) {
            handler.setHostName((String)(environmentReader.getHostName() != null ? environmentReader.getHostName() + ":" + environmentReader.getServerName() : environmentReader.getServerName()));
        } else {
            handler.setHostName(environmentReader.getHostName());
        }
        handler.setAppName(SyslogAuditLogHandlerResourceDefinition.resolveAppName(context, handlerModel.get(APP_NAME.getName()), environmentReader));
        handler.setSyslogType(SyslogHandler.SyslogType.valueOf((String)SYSLOG_FORMAT.resolveModelAttribute(context, handlerModel).asString()));
        handler.setTruncate(TRUNCATE.resolveModelAttribute(context, handlerModel).asBoolean());
        if (handlerModel.hasDefined(MAX_LENGTH.getName())) {
            handler.setMaxLength(MAX_LENGTH.resolveModelAttribute(context, handlerModel).asInt());
        }
        if ((protocols = handlerResource.getChildren("protocol")).isEmpty()) {
            throw DomainManagementLogger.ROOT_LOGGER.noSyslogProtocol();
        }
        Resource.ResourceEntry protocol = (Resource.ResourceEntry)protocols.iterator().next();
        SyslogAuditLogHandler.Transport transport = SyslogAuditLogHandler.Transport.valueOf((String)protocol.getPathElement().getValue().toUpperCase(Locale.ENGLISH));
        handler.setTransport(transport);
        try {
            handler.setSyslogServerAddress(InetAddress.getByName(SyslogAuditLogProtocolResourceDefinition.HOST.resolveModelAttribute(context, protocol.getModel()).asString()));
        }
        catch (UnknownHostException e) {
            throw new OperationFailedException((Throwable)e);
        }
        handler.setPort(SyslogAuditLogProtocolResourceDefinition.PORT.resolveModelAttribute(context, protocol.getModel()).asInt());
        if (transport != SyslogAuditLogHandler.Transport.UDP) {
            handler.setMessageTransfer(SyslogAuditLogHandler.MessageTransfer.valueOf((String)SyslogAuditLogProtocolResourceDefinition.Tcp.MESSAGE_TRANSFER.resolveModelAttribute(context, protocol.getModel()).asString()));
            handler.setReconnectTimeout(SyslogAuditLogProtocolResourceDefinition.Tcp.RECONNECT_TIMEOUT.resolveModelAttribute(context, protocol.getModel()).asInt());
        }
        if (transport == SyslogAuditLogHandler.Transport.TLS) {
            Set tlsStores = protocol.getChildren("authentication");
            for (Resource.ResourceEntry storeEntry : tlsStores) {
                ModelNode storeModel = storeEntry.getModel();
                String type = storeEntry.getPathElement().getValue();
                if (type.equals("client-certificate-store")) {
                    handler.setTlsClientCertStorePassword(SyslogAuditLogHandlerResourceDefinition.resolveUndefinableAttribute(context, (AttributeDefinition)SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_PASSWORD, storeModel));
                    handler.setTlsClientCertStorePath(SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_PATH.resolveModelAttribute(context, storeModel).asString());
                    handler.setTlsClientCertStoreRelativeTo(SyslogAuditLogHandlerResourceDefinition.resolveUndefinableAttribute(context, (AttributeDefinition)SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_RELATIVE_TO, storeModel));
                    handler.setTlsClientCertStoreKeyPassword(SyslogAuditLogHandlerResourceDefinition.resolveUndefinableAttribute(context, (AttributeDefinition)SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEY_PASSWORD, storeModel));
                    continue;
                }
                if (!type.equals("truststore")) continue;
                handler.setTlsTruststorePassword(SyslogAuditLogHandlerResourceDefinition.resolveUndefinableAttribute(context, (AttributeDefinition)SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_PASSWORD, storeModel));
                handler.setTlsTrustStorePath(SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_PATH.resolveModelAttribute(context, storeModel).asString());
                handler.setTlsTrustStoreRelativeTo(SyslogAuditLogHandlerResourceDefinition.resolveUndefinableAttribute(context, (AttributeDefinition)SyslogAuditLogProtocolResourceDefinition.TlsKeyStore.KEYSTORE_RELATIVE_TO, storeModel));
            }
        }
        return handler;
    }

    private static String resolveUndefinableAttribute(OperationContext context, AttributeDefinition attr, ModelNode model) throws OperationFailedException {
        if (model.hasDefined(attr.getName())) {
            return attr.resolveModelAttribute(context, model).asString();
        }
        return null;
    }

    private static String resolveAppName(OperationContext context, ModelNode appName, EnvironmentNameReader environmentReader) throws OperationFailedException {
        if (appName.isDefined()) {
            return context.resolveExpressions(appName).asString();
        }
        if (environmentReader.getProductName() != null) {
            return environmentReader.getProductName();
        }
        return DEFAULT_APP_NAME_IF_NOT_A_PRODUCT;
    }

    static class HandlerWriteAttributeHandler
    extends AuditLogHandlerResourceDefinition.HandlerWriteAttributeHandler {
        private final EnvironmentNameReader environmentReader;

        public HandlerWriteAttributeHandler(ManagedAuditLogger auditLogger, PathManagerService pathManager, EnvironmentNameReader environmentReader) {
            super(auditLogger, pathManager);
            this.environmentReader = environmentReader;
        }

        @Override
        protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource resource) throws OperationFailedException {
            super.finishModelStage(context, operation, attributeName, newValue, oldValue, resource);
            if (attributeName.equals("keystore-password-credential-reference") || attributeName.equals("key-password-credential-reference")) {
                CredentialReference.handleCredentialReferenceUpdate((OperationContext)context, (ModelNode)resource.getModel().get(attributeName), (String)attributeName);
            }
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
            if (super.handleApplyAttributeRuntime(context, operation, attributeName, resolvedValue, currentValue, handbackHolder)) {
                return false;
            }
            if (attributeName.equals(APP_NAME.getName())) {
                this.auditLogger.updateSyslogHandlerAppName(Util.getNameFromAddress((ModelNode)operation.require("address")), SyslogAuditLogHandlerResourceDefinition.resolveAppName(context, operation.get("value"), this.environmentReader));
            } else if (attributeName.equals(FACILITY.getName())) {
                this.auditLogger.updateSyslogHandlerFacility(Util.getNameFromAddress((ModelNode)operation.require("address")), SyslogAuditLogHandler.Facility.valueOf((String)resolvedValue.asString()));
            } else if (attributeName.equals("reconnect-timeout")) {
                PathAddress addr = PathAddress.pathAddress((ModelNode)operation.require("address"));
                addr = addr.subAddress(0, addr.size() - 1);
                this.auditLogger.updateSyslogHandlerReconnectTimeout(Util.getNameFromAddress((PathAddress)addr), resolvedValue.asInt());
            } else {
                if (attributeName.equals("keystore-password-credential-reference") || attributeName.equals("key-password-credential-reference")) {
                    return CredentialReference.applyCredentialReferenceUpdateToRuntime((OperationContext)context, (ModelNode)operation, (ModelNode)resolvedValue, (ModelNode)currentValue, (String)attributeName);
                }
                this.auditLogger.getUpdater().updateHandler((AuditLogHandler)SyslogAuditLogHandlerResourceDefinition.createHandler(this.pathManager, context, this.environmentReader));
            }
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
            if (super.handlerRevertUpdateToRuntime(context, operation, attributeName, valueToRestore, valueToRevert, handback)) {
                return;
            }
            if (attributeName.equals(APP_NAME.getName())) {
                this.auditLogger.updateSyslogHandlerAppName(Util.getNameFromAddress((ModelNode)operation.require("address")), SyslogAuditLogHandlerResourceDefinition.resolveAppName(context, valueToRestore, this.environmentReader));
            } else if (attributeName.equals(FACILITY.getName())) {
                this.auditLogger.updateSyslogHandlerFacility(Util.getNameFromAddress((ModelNode)operation.require("address")), SyslogAuditLogHandler.Facility.valueOf((String)valueToRestore.asString()));
            } else if (attributeName.equals("reconnect-timeout")) {
                PathAddress addr = PathAddress.pathAddress((ModelNode)operation.require("address"));
                addr = addr.subAddress(0, addr.size() - 1);
                this.auditLogger.updateSyslogHandlerReconnectTimeout(Util.getNameFromAddress((PathAddress)addr), valueToRestore.asInt());
            } else if (attributeName.equals("keystore-password-credential-reference") || attributeName.equals("key-password-credential-reference")) {
                CredentialReference.rollbackCredentialStoreUpdate((AttributeDefinition)context.getResourceRegistration().getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName).getAttributeDefinition(), (OperationContext)context, (ModelNode)valueToRevert);
            } else {
                this.auditLogger.getUpdater().rollbackChanges();
            }
        }
    }

    static class SyslogAuditLogHandlerAddHandler
    extends AbstractAddStepHandler {
        private final PathManagerService pathManager;
        private final ManagedAuditLogger auditLogger;
        private final EnvironmentNameReader environmentReader;

        private SyslogAuditLogHandlerAddHandler(ManagedAuditLogger auditLogger, PathManagerService pathManager, EnvironmentNameReader environmentReader) {
            this.pathManager = pathManager;
            this.auditLogger = auditLogger;
            this.environmentReader = environmentReader;
        }

        protected void populateModel(OperationContext context, ModelNode operation, final Resource resource) throws OperationFailedException {
            super.populateModel(context, operation, resource);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    HandlerUtil.checkNoOtherHandlerWithTheSameName(context);
                    String formatterName = resource.getModel().get(AuditLogHandlerResourceDefinition.FORMATTER.getName()).asString();
                    if (!HandlerUtil.lookForFormatter(context, context.getCurrentAddress(), formatterName)) {
                        throw DomainManagementLogger.ROOT_LOGGER.noFormatterCalled(formatterName);
                    }
                }
            }, OperationContext.Stage.MODEL);
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            this.auditLogger.getUpdater().addHandler((AuditLogHandler)SyslogAuditLogHandlerResourceDefinition.createHandler(this.pathManager, context, this.environmentReader));
        }

        protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
            this.auditLogger.getUpdater().rollbackChanges();
        }
    }

    static class SyslogAuditLogHandlerRemoveHandler
    extends AbstractRemoveStepHandler {
        private final ManagedAuditLogger auditLogger;

        SyslogAuditLogHandlerRemoveHandler(ManagedAuditLogger auditLogger) {
            this.auditLogger = auditLogger;
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            String name = Util.getNameFromAddress((ModelNode)operation.require("address"));
            this.auditLogger.getUpdater().removeHandler(name);
            context.removeService(SyslogAuditLogHandlerService.SYSLOG_AUDIT_HANDLER.append(new String[]{name}));
        }

        protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            this.auditLogger.getUpdater().rollbackChanges();
            String name = Util.getNameFromAddress((ModelNode)operation.require("address"));
            Resource handlerResource = context.readResourceFromRoot(SyslogAuditLogHandlerResourceDefinition.getAffectedHandlerAddress(context));
            SyslogAuditLogHandlerService.installService(context, SyslogAuditLogHandlerService.SYSLOG_AUDIT_HANDLER.append(new String[]{name}), handlerResource);
        }
    }
}

