/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.spi.ParameterizedBeanReference;
import org.hibernate.search.engine.environment.thread.spi.ThreadPoolProvider;
import org.hibernate.search.engine.mapper.mapping.building.spi.BackendsInfo;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexBindingContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexedEntityBindingMapperContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappedIndexManagerBuilder;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappedIndexManagerFactory;
import org.hibernate.search.engine.mapper.mapping.building.spi.Mapper;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingAbortedException;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingBuildContext;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingPartialBuildState;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.engine.mapper.model.spi.TypeMetadataContributorProvider;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.tenancy.spi.TenancyMode;
import org.hibernate.search.mapper.pojo.automaticindexing.ReindexOnUpdate;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuildingHelper;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorTypeNode;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolver;
import org.hibernate.search.mapper.pojo.bridge.IdentifierBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.BoundRoutingBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.impl.RoutingBindingContextImpl;
import org.hibernate.search.mapper.pojo.bridge.mapping.impl.BridgeResolver;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.RoutingBinder;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorBinder;
import org.hibernate.search.mapper.pojo.identity.impl.IdentityMappingMode;
import org.hibernate.search.mapper.pojo.identity.impl.PojoRootIdentityMappingCollector;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoIndexModelBinder;
import org.hibernate.search.mapper.pojo.mapping.building.impl.PojoMappingHelper;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoContainedTypeExtendedMappingCollector;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoIndexMappingCollectorTypeNode;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoIndexedTypeExtendedMappingCollector;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoMapperDelegate;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.impl.AbstractPojoTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoMappingDelegateImpl;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoTypeManagerContainer;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoTypeAdditionalMetadataProvider;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoEntityTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoIndexedTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.dependency.impl.PojoRoutingIndexingDependencyConfigurationContextImpl;
import org.hibernate.search.mapper.pojo.model.impl.PojoModelTypeRootElement;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.spi.PojoBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.processing.building.impl.PojoIndexingProcessorOriginalTypeNodeBuilder;
import org.hibernate.search.mapper.pojo.reporting.spi.PojoEventContexts;
import org.hibernate.search.mapper.pojo.search.definition.impl.PojoSearchQueryElementRegistry;
import org.hibernate.search.mapper.pojo.search.definition.impl.PojoSearchQueryElementRegistryBuilder;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoMapper<MPBS extends MappingPartialBuildState>
implements Mapper<MPBS> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ContextualFailureCollector failureCollector;
    private final TypeMetadataContributorProvider<PojoTypeMetadataContributor> contributorProvider;
    private final BeanReference<? extends IdentifierBridge<Object>> providedIdentifierBridge;
    private final IdentityMappingMode containedEntityIdentityMappingMode;
    private final TenancyMode tenancyMode;
    private final ReindexOnUpdate defaultReindexOnUpdate;
    private final FailureHandler failureHandler;
    private final ThreadPoolProvider threadPoolProvider;
    private final PojoMapperDelegate<MPBS> delegate;
    private final PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider;
    private final ContainerExtractorBinder extractorBinder;
    private final PojoMappingHelper mappingHelper;
    private final Set<PojoRawTypeModel<?>> entityTypes = new LinkedHashSet();
    private final Set<PojoRawTypeModel<?>> indexedEntityTypes = new LinkedHashSet();
    private final Set<PojoRawTypeModel<?>> initialMappedTypes = new LinkedHashSet();
    private final PojoTypeManagerContainer.Builder typeManagerContainerBuilder = PojoTypeManagerContainer.builder();
    private PojoSearchQueryElementRegistry searchQueryElementRegistry;
    private boolean closed = false;

    public PojoMapper(MappingBuildContext buildContext, TypeMetadataContributorProvider<PojoTypeMetadataContributor> contributorProvider, PojoBootstrapIntrospector introspector, ContainerExtractorBinder extractorBinder, BridgeResolver bridgeResolver, BeanReference<? extends IdentifierBridge<Object>> providedIdentifierBridge, IdentityMappingMode containedEntityIdentityMappingMode, TenancyMode tenancyMode, ReindexOnUpdate defaultReindexOnUpdate, PojoMapperDelegate<MPBS> delegate) {
        this.failureCollector = buildContext.failureCollector();
        this.contributorProvider = contributorProvider;
        this.containedEntityIdentityMappingMode = containedEntityIdentityMappingMode;
        this.tenancyMode = tenancyMode;
        this.defaultReindexOnUpdate = defaultReindexOnUpdate;
        this.failureHandler = buildContext.failureHandler();
        this.threadPoolProvider = buildContext.threadPoolProvider();
        this.delegate = delegate;
        this.providedIdentifierBridge = providedIdentifierBridge;
        this.typeAdditionalMetadataProvider = new PojoTypeAdditionalMetadataProvider(buildContext.beanResolver(), contributorProvider);
        this.extractorBinder = extractorBinder;
        PojoIndexModelBinder indexModelBinder = new PojoIndexModelBinder(buildContext, introspector, extractorBinder, bridgeResolver, this.typeAdditionalMetadataProvider);
        this.mappingHelper = new PojoMappingHelper(buildContext.beanResolver(), this.failureCollector, contributorProvider, introspector, this.typeAdditionalMetadataProvider, indexModelBinder);
    }

    public void closeOnFailure() {
        if (!this.closed) {
            this.closed = true;
            try (Closer closer = new Closer();){
                closer.push(PojoTypeManagerContainer.Builder::closeOnFailure, (Object)this.typeManagerContainerBuilder);
                closer.push(PojoMapperDelegate::closeOnFailure, this.delegate);
            }
        }
    }

    public void prepareMappedTypes(BackendsInfo backendsInfo) {
        Set encounteredTypes = this.contributorProvider.typesContributedTo();
        for (MappableTypeModel mappableTypeModel : encounteredTypes) {
            try {
                if (!(mappableTypeModel instanceof PojoRawTypeModel)) {
                    throw new AssertionFailure("Expected the mappable type model to be an instance of " + String.valueOf(PojoRawTypeModel.class) + ", got " + String.valueOf(mappableTypeModel) + " instead.");
                }
                PojoRawTypeModel rawTypeModel = (PojoRawTypeModel)mappableTypeModel;
                this.prepareEntityOrIndexedType(rawTypeModel, backendsInfo);
                this.initialMappedTypes.add(rawTypeModel);
            }
            catch (RuntimeException e) {
                this.failureCollector.withContext(EventContexts.fromType((MappableTypeModel)mappableTypeModel)).add((Throwable)e);
            }
        }
        log.detectedMappedTypes(this.entityTypes, this.indexedEntityTypes, this.initialMappedTypes);
        for (PojoRawTypeModel pojoRawTypeModel : this.entityTypes) {
            try {
                PojoEntityTypeAdditionalMetadata metadata = this.typeAdditionalMetadataProvider.get(pojoRawTypeModel).getEntityTypeMetadata().orElseThrow(() -> new AssertionFailure("Missing metadata for entity type '" + String.valueOf(entityType)));
                this.typeManagerContainerBuilder.addEntity(pojoRawTypeModel, metadata.getEntityName(), metadata.getSecondaryEntityName());
            }
            catch (RuntimeException e) {
                this.failureCollector.withContext(EventContexts.fromType((MappableTypeModel)pojoRawTypeModel)).add((Throwable)e);
            }
        }
    }

    private void prepareEntityOrIndexedType(PojoRawTypeModel<?> rawTypeModel, BackendsInfo backendsInfo) {
        PojoTypeAdditionalMetadata metadata = this.typeAdditionalMetadataProvider.get(rawTypeModel);
        if (metadata.isEntity()) {
            this.entityTypes.add(rawTypeModel);
        }
        Optional<PojoIndexedTypeAdditionalMetadata> indexedTypeMetadataOptional = metadata.getIndexedTypeMetadata();
        if (!rawTypeModel.isAbstract() && indexedTypeMetadataOptional.isPresent()) {
            if (!metadata.getEntityTypeMetadata().isPresent()) {
                throw log.missingEntityTypeMetadata(rawTypeModel);
            }
            PojoIndexedTypeAdditionalMetadata indexedTypeMetadata = indexedTypeMetadataOptional.get();
            backendsInfo.collect(indexedTypeMetadata.backendName(), this.tenancyMode);
            this.indexedEntityTypes.add(rawTypeModel);
        }
    }

    public void mapTypes(MappedIndexManagerFactory indexManagerFactory) {
        for (PojoRawTypeModel<?> pojoRawTypeModel : this.indexedEntityTypes) {
            try {
                this.mapIndexedType(pojoRawTypeModel, indexManagerFactory);
            }
            catch (RuntimeException runtimeException) {
                this.failureCollector.withContext(EventContexts.fromType(pojoRawTypeModel)).add((Throwable)runtimeException);
            }
        }
        if (!this.failureCollector.hasFailure()) {
            this.mappingHelper.checkPathTrackers();
        }
        PojoSearchQueryElementRegistryBuilder searchQueryElementRegistryBuilder = new PojoSearchQueryElementRegistryBuilder(this.mappingHelper);
        try {
            for (PojoRawTypeModel<?> pojoRawTypeModel : this.initialMappedTypes) {
                searchQueryElementRegistryBuilder.process(pojoRawTypeModel);
            }
            this.searchQueryElementRegistry = searchQueryElementRegistryBuilder.build();
        }
        catch (RuntimeException runtimeException) {
            searchQueryElementRegistryBuilder.closeOnFailure();
        }
        if (!this.failureCollector.hasFailure()) {
            this.mappingHelper.checkPathTrackers();
        }
    }

    private <E> void mapIndexedType(PojoRawTypeModel<E> indexedEntityType, MappedIndexManagerFactory indexManagerFactory) {
        PojoTypeAdditionalMetadata metadata = this.typeAdditionalMetadataProvider.get(indexedEntityType);
        PojoEntityTypeAdditionalMetadata entityTypeMetadata = metadata.getEntityTypeMetadata().get();
        PojoIndexedTypeAdditionalMetadata indexedTypeMetadata = metadata.getIndexedTypeMetadata().get();
        String entityName = entityTypeMetadata.getEntityName();
        String indexName = indexedTypeMetadata.indexName().orElse(entityName);
        MappedIndexManagerBuilder indexManagerBuilder = indexManagerFactory.createMappedIndexManager((IndexedEntityBindingMapperContext)this.mappingHelper, this.delegate, indexedTypeMetadata.backendName(), indexName, entityName);
        Optional<RoutingBinder> routingBinderOptional = indexedTypeMetadata.routingBinder();
        BoundRoutingBridge<E> routingBridge = null;
        if (routingBinderOptional.isPresent()) {
            PojoBootstrapIntrospector introspector = this.mappingHelper.introspector();
            PojoModelTypeRootElement<E> pojoModelRootElement = new PojoModelTypeRootElement<E>(BoundPojoModelPath.root(indexedEntityType), introspector, this.typeAdditionalMetadataProvider);
            PojoRoutingIndexingDependencyConfigurationContextImpl<E> dependencyContext = new PojoRoutingIndexingDependencyConfigurationContextImpl<E>(introspector, this.extractorBinder, this.typeAdditionalMetadataProvider, indexedEntityType);
            routingBridge = new RoutingBindingContextImpl<E>(this.mappingHelper.beanResolver(), introspector, indexedEntityType, pojoModelRootElement, dependencyContext, indexedTypeMetadata.routingBinderParams()).applyBinder(routingBinderOptional.get());
        }
        PojoRootIdentityMappingCollector<E> identityMappingCollector = new PojoRootIdentityMappingCollector<E>(indexedEntityType, this.mappingHelper, Optional.of(indexManagerBuilder.rootBindingContext()), this.providedIdentifierBridge);
        PojoIndexingProcessorOriginalTypeNodeBuilder<E> indexingProcessorBuilder = new PojoIndexingProcessorOriginalTypeNodeBuilder<E>(BoundPojoModelPath.root(indexedEntityType), this.mappingHelper, (IndexBindingContext)indexManagerBuilder.rootBindingContext(), identityMappingCollector, Collections.emptyList());
        PojoIndexedTypeExtendedMappingCollector extendedMappingCollector = this.delegate.createIndexedTypeExtendedMappingCollector(indexedEntityType, entityName);
        this.typeManagerContainerBuilder.addIndexed(indexedEntityType, entityName, entityTypeMetadata.getSecondaryEntityName(), identityMappingCollector, extendedMappingCollector, routingBridge, indexingProcessorBuilder, indexManagerBuilder);
        this.collectIndexMapping(indexedEntityType, indexingProcessorBuilder);
    }

    public MPBS prepareBuild() throws MappingAbortedException {
        PojoMappingDelegateImpl mappingDelegate;
        PojoImplicitReindexingResolverBuildingHelper reindexingResolverBuildingHelper = new PojoImplicitReindexingResolverBuildingHelper(this.extractorBinder, this.typeAdditionalMetadataProvider, this.entityTypes, this.defaultReindexOnUpdate);
        try {
            for (PojoIndexedTypeManager.Builder<?> builder : this.typeManagerContainerBuilder.indexed.values()) {
                this.preBuildIndexingProcessorAndCollectDependencies(builder, reindexingResolverBuildingHelper);
            }
            if (this.failureCollector.hasFailure()) {
                throw new MappingAbortedException();
            }
            for (PojoIndexedTypeManager.Builder<?> builder : this.typeManagerContainerBuilder.indexed.values()) {
                try {
                    this.preBuildIndexed(builder, reindexingResolverBuildingHelper);
                }
                catch (RuntimeException e) {
                    this.failureCollector.withContext(PojoEventContexts.fromType(builder.typeModel)).add((Throwable)e);
                }
            }
            for (PojoRawTypeModel pojoRawTypeModel : this.entityTypes) {
                try {
                    this.preBuildIfContained(pojoRawTypeModel, reindexingResolverBuildingHelper);
                }
                catch (RuntimeException e) {
                    this.failureCollector.withContext(PojoEventContexts.fromType(pojoRawTypeModel)).add((Throwable)e);
                }
            }
            if (this.failureCollector.hasFailure()) {
                throw new MappingAbortedException();
            }
            PojoTypeManagerContainer typeManagerContainer = this.typeManagerContainerBuilder.build(reindexingResolverBuildingHelper);
            mappingDelegate = new PojoMappingDelegateImpl(this.threadPoolProvider, this.failureHandler, this.tenancyMode, typeManagerContainer, this.searchQueryElementRegistry);
        }
        catch (RuntimeException | MappingAbortedException e) {
            ((SuppressingCloser)((SuppressingCloser)((SuppressingCloser)new SuppressingCloser(e).push(PojoSearchQueryElementRegistry::close, (Object)this.searchQueryElementRegistry)).push(PojoImplicitReindexingResolverBuildingHelper::closeOnFailure, (Object)reindexingResolverBuildingHelper)).push(PojoTypeManagerContainer.Builder::closeOnFailure, (Object)this.typeManagerContainerBuilder)).push(PojoMapperDelegate::closeOnFailure, this.delegate);
            throw e;
        }
        this.closed = true;
        try {
            return (MPBS)((MappingPartialBuildState)this.delegate.prepareBuild(mappingDelegate));
        }
        catch (RuntimeException e) {
            ((SuppressingCloser)new SuppressingCloser((Throwable)e).push(PojoMapperDelegate::closeOnFailure, this.delegate)).push((AutoCloseable)mappingDelegate);
            throw e;
        }
    }

    private <T> void collectIndexMapping(PojoRawTypeModel<T> type, PojoIndexMappingCollectorTypeNode collector) {
        for (PojoTypeMetadataContributor contributor : this.contributorProvider.get(type)) {
            contributor.contributeIndexMapping(collector);
        }
    }

    private <E> void preBuildIndexingProcessorAndCollectDependencies(PojoIndexedTypeManager.Builder<E> builder, PojoImplicitReindexingResolverBuildingHelper helper) {
        PojoIndexingDependencyCollectorTypeNode dependencyCollector = helper.createDependencyCollector(builder.typeModel);
        if (builder.routingBridge != null) {
            builder.routingBridge.contributeDependencies(dependencyCollector);
        }
        builder.preBuildIndexingProcessor(dependencyCollector);
    }

    private <E> void preBuildIndexed(PojoIndexedTypeManager.Builder<E> builder, PojoImplicitReindexingResolverBuildingHelper helper) {
        builder.preBuildIdentifierMapping(IdentityMappingMode.REQUIRED);
        builder.reindexingResolver(helper.build(builder.typeModel));
        this.preBuildOtherMetadata(builder, helper);
        builder.preBuildIndexManager();
    }

    private <E> void preBuildOtherMetadata(AbstractPojoTypeManager.Builder<E> builder, PojoImplicitReindexingResolverBuildingHelper helper) {
        PojoRawTypeModel typeModel = builder.typeModel;
        Optional<ParameterizedBeanReference> loadingBinderRefOptional = typeModel.ascendingSuperTypes().map(superType -> this.typeAdditionalMetadataProvider.get((PojoRawTypeModel<?>)superType).getEntityTypeMetadata().map(PojoEntityTypeAdditionalMetadata::getLoadingBinderRef).orElse(null)).filter(Objects::nonNull).findFirst();
        builder.preBuildOtherMetadata(this.mappingHelper.beanResolver(), this.mappingHelper.introspector(), helper.isSingleConcreteTypeInEntityHierarchy(typeModel), helper.runtimePathsBuildingHelper(typeModel).pathOrdinals(), loadingBinderRefOptional);
    }

    private <E> void preBuildIfContained(PojoRawTypeModel<E> entityType, PojoImplicitReindexingResolverBuildingHelper reindexingResolverBuildingHelper) {
        if (entityType.isAbstract() || this.typeManagerContainerBuilder.indexed.containsKey(entityType)) {
            return;
        }
        PojoEntityTypeAdditionalMetadata entityTypeMetadata = this.typeAdditionalMetadataProvider.get(entityType).getEntityTypeMetadata().orElseThrow(() -> new AssertionFailure("Missing metadata for entity type '" + String.valueOf(entityType)));
        Optional<PojoImplicitReindexingResolver<E>> reindexingResolverOptional = reindexingResolverBuildingHelper.buildOptional(entityType);
        if (reindexingResolverOptional.isEmpty()) {
            return;
        }
        String entityName = entityTypeMetadata.getEntityName();
        PojoContainedTypeExtendedMappingCollector extendedMappingCollector = this.delegate.createContainedTypeExtendedMappingCollector(entityType, entityName);
        PojoRootIdentityMappingCollector<E> identityMappingCollector = new PojoRootIdentityMappingCollector<E>(entityType, this.mappingHelper, Optional.empty(), this.providedIdentifierBridge);
        PojoContainedTypeManager.Builder<E> builder = this.typeManagerContainerBuilder.addContained(entityType, entityName, entityTypeMetadata.getSecondaryEntityName(), identityMappingCollector, extendedMappingCollector);
        this.collectIndexMapping(entityType, identityMappingCollector.toMappingCollectorRootNode());
        builder.preBuildIdentifierMapping(this.containedEntityIdentityMappingMode);
        builder.reindexingResolver(reindexingResolverOptional.get());
        this.preBuildOtherMetadata(builder, reindexingResolverBuildingHelper);
    }
}

