/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jboss.as.domain.controller.HostConnectionInfo;
import org.jboss.as.host.controller.mgmt.SlaveHostPinger;

public class DomainSlaveHostRegistrations {
    private static final long TTL = TimeUnit.DAYS.toMillis(7L);
    private final Map<String, DomainHostConnection> registrations = new ConcurrentHashMap<String, DomainHostConnection>();
    private static final EvictionPolicy EXPIRED = new EvictionPolicy(){

        @Override
        boolean evictEntry(DomainHostConnection entry) {
            long expired = System.currentTimeMillis() - TTL;
            List<HostConnectionInfo.Event> events = entry.events;
            ArrayList<HostConnectionInfo.Event> newEvents = new ArrayList<HostConnectionInfo.Event>();
            for (HostConnectionInfo.Event event : events) {
                if (event.getTimestamp() < expired) continue;
                newEvents.add(event);
            }
            entry.events = newEvents;
            if (!newEvents.isEmpty()) {
                return false;
            }
            return !entry.isConnected();
        }
    };
    private static final EvictionPolicy DISCONNECTED = new EvictionPolicy(){

        @Override
        boolean evictEntry(DomainHostConnection entry) {
            return !entry.isConnected();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerHost(String hostName, SlaveHostPinger pinger, String address) {
        DomainSlaveHostRegistrations domainSlaveHostRegistrations = this;
        synchronized (domainSlaveHostRegistrations) {
            DomainHostConnection registration = this.registrations.get(hostName);
            List<HostConnectionInfo.Event> events = registration == null ? new ArrayList<HostConnectionInfo.Event>() : registration.events;
            events.add(HostConnectionInfo.Events.create(HostConnectionInfo.EventType.REGISTERED, address));
            registration = new DomainHostConnection(hostName, pinger, address, events);
            this.registrations.put(hostName, registration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean unregisterHost(String hostName, HostConnectionInfo.Event event) {
        DomainSlaveHostRegistrations domainSlaveHostRegistrations = this;
        synchronized (domainSlaveHostRegistrations) {
            DomainHostConnection registration = this.registrations.get(hostName);
            if (registration == null) {
                return false;
            }
            List<HostConnectionInfo.Event> events = registration.events;
            events.add(event);
            registration = new DomainHostConnection(hostName, events);
            this.registrations.put(hostName, registration);
        }
        return true;
    }

    protected boolean contains(String host) {
        return this.registrations.containsKey(host);
    }

    protected Set<String> getHosts() {
        return this.registrations.keySet();
    }

    protected DomainHostConnection getRegistration(String hostName) {
        return this.registrations.get(hostName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEvent(String hostName, HostConnectionInfo.Event event) {
        DomainSlaveHostRegistrations domainSlaveHostRegistrations = this;
        synchronized (domainSlaveHostRegistrations) {
            DomainHostConnection registration = this.registrations.get(hostName);
            if (registration == null) {
                registration = new DomainHostConnection(hostName);
                this.registrations.put(hostName, registration);
            }
            ArrayList<HostConnectionInfo.Event> events = new ArrayList<HostConnectionInfo.Event>(registration.events);
            events.add(event);
            registration.events = events;
        }
    }

    public void pruneExpired() {
        this.evictEntries(EXPIRED);
    }

    public void pruneDisconnected() {
        this.evictEntries(DISCONNECTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evictEntries(EvictionPolicy policy) {
        DomainSlaveHostRegistrations domainSlaveHostRegistrations = this;
        synchronized (domainSlaveHostRegistrations) {
            Iterator<DomainHostConnection> i = this.registrations.values().iterator();
            while (i.hasNext()) {
                DomainHostConnection registration = i.next();
                if (!policy.evictEntry(registration)) continue;
                i.remove();
            }
        }
    }

    static class DomainHostConnection
    implements HostConnectionInfo,
    Comparable<HostConnectionInfo> {
        private final String hostName;
        private final String address;
        private final SlaveHostPinger pinger;
        private volatile boolean connected;
        private volatile List<HostConnectionInfo.Event> events;

        DomainHostConnection(String hostName) {
            this(hostName, new ArrayList<HostConnectionInfo.Event>());
        }

        DomainHostConnection(String hostName, List<HostConnectionInfo.Event> events) {
            this.hostName = hostName;
            this.connected = false;
            this.address = null;
            this.pinger = null;
            this.events = events;
        }

        DomainHostConnection(String hostName, SlaveHostPinger pinger, String address, List<HostConnectionInfo.Event> events) {
            this.hostName = hostName;
            this.pinger = pinger;
            this.events = events;
            this.address = address;
            this.connected = true;
        }

        @Override
        public String getHostName() {
            return this.hostName;
        }

        @Override
        public boolean isConnected() {
            return this.connected;
        }

        @Override
        public List<HostConnectionInfo.Event> getEvents() {
            return this.events;
        }

        protected String getAddress() {
            return this.address;
        }

        protected Long getRemoteConnectionId() {
            if (this.pinger != null) {
                return this.pinger.getRemoteConnectionID();
            }
            return null;
        }

        protected SlaveHostPinger getPinger() {
            return this.pinger;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DomainHostConnection that = (DomainHostConnection)o;
            return this.hostName.equals(that.hostName);
        }

        public int hashCode() {
            return this.hostName.hashCode();
        }

        @Override
        public int compareTo(HostConnectionInfo o) {
            return this.hostName.compareTo(o.getHostName());
        }
    }

    static abstract class EvictionPolicy {
        EvictionPolicy() {
        }

        abstract boolean evictEntry(DomainHostConnection var1);
    }
}

