/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.naming.AuthenticationException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.spi.core.security.jaas.AuditLoginModule;
import org.apache.activemq.artemis.spi.core.security.jaas.LDAPLoginProperty;
import org.apache.activemq.artemis.spi.core.security.jaas.NoCacheLoginException;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPLoginModule
implements AuditLoginModule {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected DirContext context;
    private Subject subject;
    private CallbackHandler handler;
    private final Set<LDAPLoginProperty> config = new HashSet<LDAPLoginProperty>();
    private String username;
    private final Set<RolePrincipal> groups = new HashSet<RolePrincipal>();
    private boolean userAuthenticated = false;
    private boolean authenticateUser = true;
    private Subject brokerGssapiIdentity = null;
    private boolean isRoleAttributeSet = false;
    private String roleAttributeName = null;
    private List<String> noCacheExceptions;
    private String codecClass = null;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.handler = callbackHandler;
        this.config.clear();
        for (Map.Entry<String, ?> entry : options.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            this.config.add(new LDAPLoginProperty(entry.getKey(), (String)entry.getValue()));
        }
        if (this.isLoginPropertySet(ConfigKey.AUTHENTICATE_USER)) {
            this.authenticateUser = Boolean.parseBoolean(this.getLDAPPropertyValue(ConfigKey.AUTHENTICATE_USER));
        }
        this.isRoleAttributeSet = this.isLoginPropertySet(ConfigKey.ROLE_NAME);
        this.roleAttributeName = this.getLDAPPropertyValue(ConfigKey.ROLE_NAME);
        this.codecClass = this.getLDAPPropertyValue(ConfigKey.PASSWORD_CODEC);
        if (this.isLoginPropertySet(ConfigKey.NO_CACHE_EXCEPTIONS)) {
            this.noCacheExceptions = Arrays.asList(this.getLDAPPropertyValue(ConfigKey.NO_CACHE_EXCEPTIONS).split(","));
            this.noCacheExceptions.replaceAll(String::trim);
        } else {
            this.noCacheExceptions = Collections.emptyList();
        }
    }

    private String getPlainPassword(String password) {
        try {
            return PasswordMaskingUtil.resolveMask((String)password, (String)this.codecClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to decode password", e);
        }
    }

    @Override
    public boolean login() throws LoginException {
        try {
            if (!this.authenticateUser) {
                return false;
            }
            Callback[] callbacks = new Callback[]{new NameCallback("User name"), new PasswordCallback("Password", false)};
            try {
                this.handler.handle(callbacks);
            }
            catch (IOException | UnsupportedCallbackException e) {
                throw (LoginException)new LoginException().initCause(e);
            }
            String password = null;
            this.username = ((NameCallback)callbacks[0]).getName();
            if (this.username == null) {
                return false;
            }
            if (((PasswordCallback)callbacks[1]).getPassword() != null) {
                password = new String(((PasswordCallback)callbacks[1]).getPassword());
            }
            if (password == null || password.length() == 0) {
                throw new FailedLoginException("Password cannot be null or empty");
            }
            this.authenticate(this.username, password);
            this.userAuthenticated = true;
            return true;
        }
        catch (LoginException e) {
            throw this.handleException(e);
        }
    }

    @Override
    public boolean logout() throws LoginException {
        this.clear();
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        try {
            boolean result = this.userAuthenticated;
            Set<UserPrincipal> authenticatedUsers = this.subject.getPrincipals(UserPrincipal.class);
            Set<Principal> principals = this.subject.getPrincipals();
            if (result) {
                principals.add(new UserPrincipal(this.username));
            }
            for (UserPrincipal authenticatedUser : authenticatedUsers) {
                ArrayList<String> roles = new ArrayList<String>();
                try {
                    String dn = this.resolveDN(authenticatedUser.getName(), roles);
                    this.resolveRolesForDN(this.context, dn, authenticatedUser.getName(), roles);
                }
                catch (NamingException e) {
                    this.closeContext();
                    FailedLoginException ex = new FailedLoginException("Error contacting LDAP");
                    ex.initCause(e);
                    throw ex;
                }
            }
            principals.addAll(this.groups);
            this.clear();
            return result;
        }
        catch (LoginException e) {
            throw this.handleException(e);
        }
    }

    private LoginException handleException(LoginException e) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
        String rootCauseClass = rootCause.getClass().getName();
        if (this.noCacheExceptions.contains(rootCauseClass)) {
            return this.getNoCacheLoginException(e, rootCause);
        }
        for (String match : this.noCacheExceptions) {
            if (!Pattern.matches(match, rootCauseClass)) continue;
            return this.getNoCacheLoginException(e, rootCause);
        }
        return e;
    }

    private NoCacheLoginException getNoCacheLoginException(LoginException e, Throwable rootCause) {
        return (NoCacheLoginException)new NoCacheLoginException(rootCause.getClass().getName() + (String)(rootCause.getMessage() == null ? "" : ": " + rootCause.getMessage())).initCause(e);
    }

    private void clear() {
        this.username = null;
        this.userAuthenticated = false;
        this.closeContext();
    }

    @Override
    public boolean abort() throws LoginException {
        this.registerFailureForAudit(this.username);
        this.clear();
        return true;
    }

    protected void closeContext() {
        if (this.context != null) {
            try {
                this.context.close();
                this.context = null;
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.failedToCloseContext(e);
            }
        }
    }

    protected boolean authenticate(String username, String password) throws LoginException {
        ArrayList<String> roles = new ArrayList<String>();
        try {
            String dn = this.resolveDN(username, roles);
            if (!this.bindUser(this.context, dn, password)) {
                throw new FailedLoginException("Password does not match for user: " + username);
            }
            this.resolveRolesForDN(this.context, dn, username, roles);
        }
        catch (NamingException e) {
            this.closeContext();
            FailedLoginException ex = new FailedLoginException("Error contacting LDAP");
            ex.initCause(e);
            throw ex;
        }
        return true;
    }

    private void resolveRolesForDN(DirContext context, String dn, String username, List<String> roles) throws NamingException {
        this.addRoles(context, dn, username, roles);
        logger.debug("Roles {} for user {}", roles, (Object)username);
        for (String role : roles) {
            this.groups.add(new RolePrincipal(role));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String resolveDN(String username, List<String> roles) throws FailedLoginException {
        String dn = null;
        logger.debug("Create the LDAP initial context.");
        try {
            this.openContext();
        }
        catch (Exception ne) {
            FailedLoginException ex = new FailedLoginException("Error opening LDAP connection");
            ex.initCause(ne);
            throw ex;
        }
        if (!this.isLoginPropertySet(ConfigKey.USER_SEARCH_MATCHING)) {
            return username;
        }
        MessageFormat userSearchMatchingFormat = new MessageFormat(this.getLDAPPropertyValue(ConfigKey.USER_SEARCH_MATCHING));
        boolean userSearchSubtreeBool = Boolean.parseBoolean(this.getLDAPPropertyValue(ConfigKey.USER_SEARCH_SUBTREE));
        boolean ignorePartialResultExceptionBool = Boolean.parseBoolean(this.getLDAPPropertyValue(ConfigKey.IGNORE_PARTIAL_RESULT_EXCEPTION));
        try {
            Attribute roleNames;
            String filter = userSearchMatchingFormat.format(new String[]{this.doRFC2254Encoding(username)});
            SearchControls constraints = new SearchControls();
            if (userSearchSubtreeBool) {
                constraints.setSearchScope(2);
            } else {
                constraints.setSearchScope(1);
            }
            ArrayList<String> list = new ArrayList<String>();
            if (this.isLoginPropertySet(ConfigKey.USER_ROLE_NAME)) {
                list.add(this.getLDAPPropertyValue(ConfigKey.USER_ROLE_NAME));
            }
            String[] attribs = new String[list.size()];
            list.toArray(attribs);
            constraints.setReturningAttributes(attribs);
            if (logger.isDebugEnabled()) {
                logger.debug("Get the user DN.");
                logger.debug("Looking for the user in LDAP with ");
                logger.debug("  base DN: {}", (Object)this.getLDAPPropertyValue(ConfigKey.USER_BASE));
                logger.debug("  filter: {}", (Object)filter);
            }
            NamingEnumeration results = null;
            try {
                results = Subject.doAs(this.brokerGssapiIdentity, () -> this.context.search(this.getLDAPPropertyValue(ConfigKey.USER_BASE), filter, constraints));
            }
            catch (PrivilegedActionException e) {
                Exception cause = e.getException();
                FailedLoginException ex = new FailedLoginException("Error executing search query to resolve DN");
                ex.initCause(cause);
                throw ex;
            }
            if (results == null || !results.hasMore()) {
                throw new FailedLoginException("User " + username + " not found in LDAP.");
            }
            SearchResult result = (SearchResult)results.next();
            try {
                if (!results.hasMore()) {
                    // empty if block
                }
            }
            catch (PartialResultException e) {
                if (!ignorePartialResultExceptionBool) {
                    throw e;
                }
                logger.debug("PartialResultException encountered and ignored", (Throwable)e);
            }
            if (result.isRelative()) {
                logger.debug("LDAP returned a relative name: {}", (Object)result.getName());
                NameParser parser = this.context.getNameParser("");
                Name contextName = parser.parse(this.context.getNameInNamespace());
                Name baseName = parser.parse(this.getLDAPPropertyValue(ConfigKey.USER_BASE));
                Name entryName = parser.parse(result.getName());
                Name name = contextName.addAll(baseName);
                name = name.addAll(entryName);
                dn = name.toString();
            } else {
                logger.debug("LDAP returned an absolute name: {}", (Object)result.getName());
                try {
                    URI uri = new URI(result.getName());
                    String path = uri.getPath();
                    dn = path.startsWith("/") ? path.substring(1) : path;
                }
                catch (URISyntaxException e) {
                    this.closeContext();
                    FailedLoginException ex = new FailedLoginException("Error parsing absolute name as URI.");
                    ex.initCause(e);
                    throw ex;
                }
            }
            logger.debug("Using DN [{}] for binding.", (Object)dn);
            Attributes attrs = result.getAttributes();
            if (attrs == null) {
                throw new FailedLoginException("User found, but LDAP entry malformed: " + username);
            }
            if (!this.isLoginPropertySet(ConfigKey.USER_ROLE_NAME) || (roleNames = attrs.get(this.getLDAPPropertyValue(ConfigKey.USER_ROLE_NAME))) == null) return dn;
            NamingEnumeration<?> e = roleNames.getAll();
            while (e.hasMore()) {
                String roleDnString = (String)e.next();
                if (this.isRoleAttributeSet) {
                    LdapName ldapRoleName = new LdapName(roleDnString);
                    for (int i = 0; i < ldapRoleName.size(); ++i) {
                        Rdn candidate = ldapRoleName.getRdn(i);
                        if (!this.roleAttributeName.equals(candidate.getType())) continue;
                        roles.add((String)candidate.getValue());
                    }
                    continue;
                }
                roles.add(roleDnString);
            }
            return dn;
        }
        catch (NamingException e) {
            this.closeContext();
            FailedLoginException ex = new FailedLoginException("Error contacting LDAP");
            ex.initCause(e);
            throw ex;
        }
    }

    protected void addRoles(DirContext context, String dn, String username, List<String> currentRoles) throws NamingException {
        if (!this.isLoginPropertySet(ConfigKey.ROLE_SEARCH_MATCHING)) {
            return;
        }
        MessageFormat roleSearchMatchingFormat = new MessageFormat(this.getLDAPPropertyValue(ConfigKey.ROLE_SEARCH_MATCHING));
        boolean roleSearchSubtreeBool = Boolean.parseBoolean(this.getLDAPPropertyValue(ConfigKey.ROLE_SEARCH_SUBTREE));
        boolean expandRolesBool = Boolean.parseBoolean(this.getLDAPPropertyValue(ConfigKey.EXPAND_ROLES));
        boolean ignorePartialResultExceptionBool = Boolean.parseBoolean(this.getLDAPPropertyValue(ConfigKey.IGNORE_PARTIAL_RESULT_EXCEPTION));
        String filter = roleSearchMatchingFormat.format(new String[]{this.doRFC2254Encoding(dn), this.doRFC2254Encoding(username)});
        SearchControls constraints = new SearchControls();
        if (roleSearchSubtreeBool) {
            constraints.setSearchScope(2);
        } else {
            constraints.setSearchScope(1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Get user roles.");
            logger.debug("Looking for the user roles in LDAP with ");
            logger.debug("  base DN: {}", (Object)this.getLDAPPropertyValue(ConfigKey.ROLE_BASE));
            logger.debug("  filter: {}", (Object)filter);
        }
        HashSet<String> haveSeenNames = new HashSet<String>();
        LinkedList<String> pendingNameExpansion = new LinkedList<String>();
        NamingEnumeration results = null;
        try {
            results = Subject.doAs(this.brokerGssapiIdentity, () -> context.search(this.getLDAPPropertyValue(ConfigKey.ROLE_BASE), filter, constraints));
        }
        catch (PrivilegedActionException e) {
            Exception cause = e.getException();
            NamingException ex = new NamingException("Error executing search query to resolve roles");
            ex.initCause(cause);
            throw ex;
        }
        try {
            while (results.hasMore()) {
                SearchResult result = (SearchResult)results.next();
                if (expandRolesBool) {
                    haveSeenNames.add(result.getNameInNamespace());
                    pendingNameExpansion.add(result.getNameInNamespace());
                }
                this.addRoleAttribute(result, currentRoles);
            }
        }
        catch (PartialResultException e) {
            if (ignorePartialResultExceptionBool) {
                logger.debug("PartialResultException encountered and ignored", (Throwable)e);
            }
            throw e;
        }
        if (expandRolesBool) {
            MessageFormat expandRolesMatchingFormat = new MessageFormat(this.getLDAPPropertyValue(ConfigKey.EXPAND_ROLES_MATCHING));
            while (!pendingNameExpansion.isEmpty()) {
                String name = (String)pendingNameExpansion.remove();
                String expandFilter = expandRolesMatchingFormat.format(new String[]{name});
                if (logger.isDebugEnabled()) {
                    logger.debug("Get 'expanded' user roles.");
                    logger.debug("Looking for the 'expanded' user roles in LDAP with ");
                    logger.debug("  base DN: {}", (Object)this.getLDAPPropertyValue(ConfigKey.ROLE_BASE));
                    logger.debug("  filter: {}", (Object)expandFilter);
                }
                try {
                    results = Subject.doAs(this.brokerGssapiIdentity, () -> context.search(this.getLDAPPropertyValue(ConfigKey.ROLE_BASE), expandFilter, constraints));
                }
                catch (PrivilegedActionException e) {
                    Exception cause = e.getException();
                    NamingException ex = new NamingException("Error executing search query to expand roles");
                    ex.initCause(cause);
                    throw ex;
                }
                try {
                    while (results.hasMore()) {
                        SearchResult result = (SearchResult)results.next();
                        name = result.getNameInNamespace();
                        if (haveSeenNames.contains(name)) continue;
                        this.addRoleAttribute(result, currentRoles);
                        haveSeenNames.add(name);
                        pendingNameExpansion.add(name);
                    }
                }
                catch (PartialResultException e) {
                    if (ignorePartialResultExceptionBool) {
                        logger.debug("PartialResultException encountered and ignored", (Throwable)e);
                        continue;
                    }
                    throw e;
                }
            }
        }
    }

    protected String doRFC2254Encoding(String inputString) {
        StringBuilder buf = new StringBuilder(inputString.length());
        block7: for (int i = 0; i < inputString.length(); ++i) {
            char c = inputString.charAt(i);
            switch (c) {
                case '\\': {
                    buf.append("\\5c");
                    continue block7;
                }
                case '*': {
                    buf.append("\\2a");
                    continue block7;
                }
                case '(': {
                    buf.append("\\28");
                    continue block7;
                }
                case ')': {
                    buf.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    buf.append("\\00");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    protected boolean bindUser(DirContext context, String dn, String password) throws NamingException {
        boolean isValid = false;
        logger.debug("Binding the user.");
        context.addToEnvironment("java.naming.security.authentication", "simple");
        context.addToEnvironment("java.naming.security.principal", dn);
        context.addToEnvironment("java.naming.security.credentials", password);
        try {
            String baseDn = this.getLDAPPropertyValue(ConfigKey.CONNECTION_URL).replaceFirst(".*/", ",");
            String userDn = dn.replace(baseDn, "");
            logger.debug("Get user Attributes with dn {}", (Object)userDn);
            context.getAttributes(userDn, null);
            isValid = true;
            logger.debug("User {} successfully bound.", (Object)dn);
        }
        catch (AuthenticationException e) {
            isValid = false;
            logger.debug("Authentication failed for dn={}", (Object)dn);
        }
        if (this.isLoginPropertySet(ConfigKey.CONNECTION_USERNAME)) {
            context.addToEnvironment("java.naming.security.principal", this.getLDAPPropertyValue(ConfigKey.CONNECTION_USERNAME));
        } else {
            context.removeFromEnvironment("java.naming.security.principal");
        }
        if (this.isLoginPropertySet(ConfigKey.CONNECTION_PASSWORD)) {
            context.addToEnvironment("java.naming.security.credentials", this.getPlainPassword(this.getLDAPPropertyValue(ConfigKey.CONNECTION_PASSWORD)));
        } else {
            context.removeFromEnvironment("java.naming.security.credentials");
        }
        context.addToEnvironment("java.naming.security.authentication", this.getLDAPPropertyValue(ConfigKey.AUTHENTICATION));
        return isValid;
    }

    private void addRoleAttribute(SearchResult searchResult, List<String> roles) throws NamingException {
        if (this.isRoleAttributeSet) {
            Attribute roleAttribute = searchResult.getAttributes().get(this.roleAttributeName);
            if (roleAttribute != null) {
                roles.add((String)roleAttribute.get());
            }
        } else {
            roles.add(searchResult.getNameInNamespace());
        }
    }

    protected void openContext() throws Exception {
        if (this.context == null) {
            try {
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", this.getLDAPPropertyValue(ConfigKey.INITIAL_CONTEXT_FACTORY));
                env.put("java.naming.security.protocol", this.getLDAPPropertyValue(ConfigKey.CONNECTION_PROTOCOL));
                env.put("java.naming.provider.url", this.getLDAPPropertyValue(ConfigKey.CONNECTION_URL));
                env.put("java.naming.security.authentication", this.getLDAPPropertyValue(ConfigKey.AUTHENTICATION));
                if (this.isLoginPropertySet(ConfigKey.CONNECTION_TIMEOUT)) {
                    env.put("com.sun.jndi.ldap.connect.timeout", this.getLDAPPropertyValue(ConfigKey.CONNECTION_TIMEOUT));
                }
                if (this.isLoginPropertySet(ConfigKey.READ_TIMEOUT)) {
                    env.put("com.sun.jndi.ldap.read.timeout", this.getLDAPPropertyValue(ConfigKey.READ_TIMEOUT));
                }
                String referral = "ignore";
                if (this.getLDAPPropertyValue(ConfigKey.REFERRAL) != null) {
                    referral = this.getLDAPPropertyValue(ConfigKey.REFERRAL);
                }
                env.put("java.naming.referral", referral);
                logger.debug("Referral handling: {}", (Object)referral);
                if ("GSSAPI".equalsIgnoreCase(this.getLDAPPropertyValue(ConfigKey.AUTHENTICATION))) {
                    String configScope = this.isLoginPropertySet(ConfigKey.SASL_LOGIN_CONFIG_SCOPE) ? this.getLDAPPropertyValue(ConfigKey.SASL_LOGIN_CONFIG_SCOPE) : "broker-sasl-gssapi";
                    try {
                        LoginContext loginContext = new LoginContext(configScope);
                        loginContext.login();
                        this.brokerGssapiIdentity = loginContext.getSubject();
                    }
                    catch (LoginException e) {
                        e.printStackTrace();
                        FailedLoginException ex = new FailedLoginException("Error contacting LDAP using GSSAPI in JAAS loginConfigScope: " + configScope);
                        ex.initCause(e);
                        throw ex;
                    }
                } else {
                    if (!this.isLoginPropertySet(ConfigKey.CONNECTION_USERNAME)) {
                        throw new NamingException("Empty username is not allowed");
                    }
                    env.put("java.naming.security.principal", this.getLDAPPropertyValue(ConfigKey.CONNECTION_USERNAME));
                    if (this.isLoginPropertySet(ConfigKey.CONNECTION_PASSWORD)) {
                        env.put("java.naming.security.credentials", this.getPlainPassword(this.getLDAPPropertyValue(ConfigKey.CONNECTION_PASSWORD)));
                    } else {
                        throw new NamingException("Empty password is not allowed");
                    }
                }
                this.extendInitialEnvironment(this.config, env);
                try {
                    this.context = Subject.doAs(this.brokerGssapiIdentity, () -> new InitialDirContext(env));
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }
            catch (NamingException e) {
                this.closeContext();
                ActiveMQServerLogger.LOGGER.failedToOpenContext(e);
                throw e;
            }
        }
    }

    protected void extendInitialEnvironment(Set<LDAPLoginProperty> moduleConfig, Hashtable<String, String> initialContextEnv) {
        for (LDAPLoginProperty prop : moduleConfig) {
            String propName = prop.getPropertyName();
            if (initialContextEnv.get(propName) != null || ConfigKey.contains(propName)) continue;
            initialContextEnv.put(propName, prop.getPropertyValue());
        }
    }

    private String getLDAPPropertyValue(ConfigKey key) {
        for (LDAPLoginProperty conf : this.config) {
            if (!conf.getPropertyName().equals(key.getName())) continue;
            return conf.getPropertyValue();
        }
        return null;
    }

    private boolean isLoginPropertySet(ConfigKey key) {
        for (LDAPLoginProperty conf : this.config) {
            if (!conf.getPropertyName().equals(key.getName()) || conf.getPropertyValue() == null || "".equals(conf.getPropertyValue())) continue;
            return true;
        }
        return false;
    }

    static enum ConfigKey {
        DEBUG("debug"),
        INITIAL_CONTEXT_FACTORY("initialContextFactory"),
        CONNECTION_URL("connectionURL"),
        CONNECTION_USERNAME("connectionUsername"),
        CONNECTION_PASSWORD("connectionPassword"),
        CONNECTION_PROTOCOL("connectionProtocol"),
        AUTHENTICATION("authentication"),
        USER_BASE("userBase"),
        USER_SEARCH_MATCHING("userSearchMatching"),
        USER_SEARCH_SUBTREE("userSearchSubtree"),
        ROLE_BASE("roleBase"),
        ROLE_NAME("roleName"),
        ROLE_SEARCH_MATCHING("roleSearchMatching"),
        ROLE_SEARCH_SUBTREE("roleSearchSubtree"),
        USER_ROLE_NAME("userRoleName"),
        EXPAND_ROLES("expandRoles"),
        EXPAND_ROLES_MATCHING("expandRolesMatching"),
        SASL_LOGIN_CONFIG_SCOPE("saslLoginConfigScope"),
        AUTHENTICATE_USER("authenticateUser"),
        REFERRAL("referral"),
        IGNORE_PARTIAL_RESULT_EXCEPTION("ignorePartialResultException"),
        PASSWORD_CODEC("passwordCodec"),
        CONNECTION_TIMEOUT("connectionTimeout"),
        READ_TIMEOUT("readTimeout"),
        NO_CACHE_EXCEPTIONS("noCacheExceptions");

        private final String name;

        private ConfigKey(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        static boolean contains(String key) {
            for (ConfigKey k : ConfigKey.values()) {
                if (!k.name.equals(key)) continue;
                return true;
            }
            return false;
        }
    }
}

