/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.amqp;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingConsumerHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.smallrye.mutiny.vertx.WriteStreamSubscriber;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.streams.WriteStream;
import io.vertx.mutiny.amqp.AmqpConnection;
import io.vertx.mutiny.amqp.AmqpMessage;
import io.vertx.proton.ProtonSender;
import java.util.function.Consumer;
import java.util.function.Function;

@MutinyGen(value=io.vertx.amqp.AmqpSender.class)
public class AmqpSender
implements io.vertx.mutiny.core.streams.WriteStream<AmqpMessage> {
    public static final TypeArg<AmqpSender> __TYPE_ARG = new TypeArg(obj -> new AmqpSender((io.vertx.amqp.AmqpSender)obj), AmqpSender::getDelegate);
    private final io.vertx.amqp.AmqpSender delegate;
    static final TypeArg<AmqpMessage> TYPE_ARG_0 = new TypeArg(o1 -> AmqpMessage.newInstance((io.vertx.amqp.AmqpMessage)o1), o1 -> o1.getDelegate());
    private WriteStreamSubscriber<AmqpMessage> subscriber;

    public AmqpSender(io.vertx.amqp.AmqpSender delegate) {
        this.delegate = delegate;
    }

    public AmqpSender(Object delegate) {
        this.delegate = (io.vertx.amqp.AmqpSender)delegate;
    }

    AmqpSender() {
        this.delegate = null;
    }

    public io.vertx.amqp.AmqpSender getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmqpSender that = (AmqpSender)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @CheckReturnValue
    public synchronized WriteStreamSubscriber<AmqpMessage> toSubscriber() {
        if (this.subscriber == null) {
            Function<AmqpMessage, io.vertx.amqp.AmqpMessage> conv = AmqpMessage::getDelegate;
            this.subscriber = MutinyHelper.toSubscriber((WriteStream)this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @CheckReturnValue
    public Uni<Void> write(AmqpMessage arg0) {
        return AsyncResultUni.toUni(arg1 -> this.delegate.write((Object)arg0.getDelegate(), arg1));
    }

    public Void writeAndAwait(AmqpMessage arg0) {
        return (Void)this.write(arg0).await().indefinitely();
    }

    public void writeAndForget(AmqpMessage arg0) {
        this.write(arg0).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> end() {
        return AsyncResultUni.toUni(arg0 -> this.delegate.end(arg0));
    }

    public Void endAndAwait() {
        return (Void)this.end().await().indefinitely();
    }

    public void endAndForget() {
        this.end().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> end(AmqpMessage data) {
        return AsyncResultUni.toUni(handler -> this.delegate.end((Object)data.getDelegate(), handler));
    }

    public Void endAndAwait(AmqpMessage data) {
        return (Void)this.end(data).await().indefinitely();
    }

    public void endAndForget(AmqpMessage data) {
        this.end(data).subscribe().with(UniHelper.NOOP);
    }

    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Fluent
    private io.vertx.mutiny.core.streams.WriteStream<AmqpMessage> __drainHandler(Handler<Void> arg0) {
        this.delegate.drainHandler(arg0);
        return this;
    }

    public io.vertx.mutiny.core.streams.WriteStream<AmqpMessage> drainHandler(Runnable arg0) {
        return this.__drainHandler((Handler<Void>)((Handler)ignored -> arg0.run()));
    }

    @Fluent
    private AmqpSender __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public AmqpSender exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler((Handler<Throwable>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    public AmqpSender setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    @Fluent
    public AmqpSender send(AmqpMessage message) {
        this.delegate.send(message.getDelegate());
        return this;
    }

    @CheckReturnValue
    public Uni<Void> sendWithAck(AmqpMessage message) {
        return AsyncResultUni.toUni(acknowledgementHandler -> this.delegate.sendWithAck(message.getDelegate(), acknowledgementHandler));
    }

    public Void sendWithAckAndAwait(AmqpMessage message) {
        return (Void)this.sendWithAck(message).await().indefinitely();
    }

    @Fluent
    public AmqpSender sendWithAckAndForget(AmqpMessage message) {
        this.sendWithAck(message).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.delegate.close(handler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    public String address() {
        String ret = this.delegate.address();
        return ret;
    }

    public AmqpConnection connection() {
        AmqpConnection ret = AmqpConnection.newInstance(this.delegate.connection());
        return ret;
    }

    public long remainingCredits() {
        long ret = this.delegate.remainingCredits();
        return ret;
    }

    public ProtonSender unwrap() {
        ProtonSender ret = this.delegate.unwrap();
        return ret;
    }

    public static AmqpSender newInstance(io.vertx.amqp.AmqpSender arg) {
        return arg != null ? new AmqpSender(arg) : null;
    }
}

