/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.staxmapper;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class IntVersion
implements Comparable<IntVersion> {
    public static final CharSequence DEFAULT_DELIMITER = ".";
    private final int[] segments;

    public IntVersion(int ... segments) {
        int length;
        for (length = segments.length; length > 0 && segments[length - 1] == 0; --length) {
        }
        this.segments = Arrays.copyOf(segments, length);
    }

    public int segment(int index) {
        return index < this.segments.length ? this.segments[index] : 0;
    }

    public int segments() {
        return this.segments.length;
    }

    public int major() {
        return this.segment(0);
    }

    public int minor() {
        return this.segment(1);
    }

    public int micro() {
        return this.segment(2);
    }

    public IntStream stream() {
        return IntStream.of(this.segments);
    }

    public IntStream stream(int segments) {
        return this.segments.length >= segments ? IntStream.of(this.segments).limit(segments) : IntStream.range(0, segments).map(this::segment);
    }

    @Override
    public int compareTo(IntVersion version) {
        for (int i = 0; i < Math.max(this.segments.length, version.segments.length); ++i) {
            int result = Integer.compare(this.segment(i), version.segment(i));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.segments);
    }

    public boolean equals(Object object) {
        return this == object || object instanceof IntVersion && this.compareTo((IntVersion)object) == 0;
    }

    public String toString() {
        return this.toString(this.segments.length);
    }

    public String toString(int segments) {
        return this.toString(segments, DEFAULT_DELIMITER);
    }

    public String toString(int segments, CharSequence delimiter) {
        return this.stream(segments).mapToObj(String::valueOf).collect(Collectors.joining(delimiter));
    }
}

