/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public interface LuceneSearchPredicate
extends SearchPredicate {
    public static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    public Set<String> indexNames();

    public void checkNestableWithin(String var1);

    public Query toQuery(PredicateRequestContext var1);

    public static LuceneSearchPredicate from(LuceneSearchIndexScope<?> scope, SearchPredicate predicate) {
        if (!(predicate instanceof LuceneSearchPredicate)) {
            throw log.cannotMixLuceneSearchQueryWithOtherPredicates(predicate);
        }
        LuceneSearchPredicate casted = (LuceneSearchPredicate)predicate;
        if (!CollectionHelper.isSubset((Set)scope.hibernateSearchIndexNames(), casted.indexNames())) {
            throw log.predicateDefinedOnDifferentIndexes(predicate, casted.indexNames(), scope.hibernateSearchIndexNames(), CollectionHelper.notInTheOtherSet((Set)scope.hibernateSearchIndexNames(), casted.indexNames()));
        }
        return casted;
    }
}

