/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.util.Optional;
import java.util.Set;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.Queries;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryIndexScope;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.search.common.NamedValues;
import org.hibernate.search.engine.search.query.spi.QueryParameters;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Contracts;

public abstract class PredicateRequestContext {
    private final String nestedPath;

    private PredicateRequestContext(String nestedPath) {
        this.nestedPath = nestedPath;
    }

    public String getNestedPath() {
        return this.nestedPath;
    }

    public abstract Query appendTenantAndRoutingFilters(Query var1);

    public abstract PredicateRequestContext withNestedPath(String var1);

    public abstract NamedValues queryParameters();

    public static PredicateRequestContext withSession(LuceneSearchQueryIndexScope<?> scope, BackendSessionContext sessionContext, Set<String> routingKeys, QueryParameters parameters) {
        Contracts.assertNotNull(scope, (String)"scope");
        Contracts.assertNotNull(scope, (String)"sessionContext");
        return new FullPredicateRequestContext(null, scope, sessionContext, routingKeys, parameters);
    }

    public static PredicateRequestContext withoutSession() {
        return new LimitedPredicateRequestContext(null);
    }

    private static class FullPredicateRequestContext
    extends PredicateRequestContext {
        private final LuceneSearchQueryIndexScope<?> scope;
        private final BackendSessionContext sessionContext;
        private final Set<String> routingKeys;
        private final QueryParameters parameters;

        private FullPredicateRequestContext(String nestedPath, LuceneSearchQueryIndexScope<?> scope, BackendSessionContext sessionContext, Set<String> routingKeys, QueryParameters parameters) {
            super(nestedPath);
            this.scope = scope;
            this.sessionContext = sessionContext;
            this.routingKeys = routingKeys;
            this.parameters = parameters;
        }

        @Override
        public Query appendTenantAndRoutingFilters(Query originalFilterQuery) {
            BooleanQuery filter;
            Query tenantFilter;
            BooleanQuery.Builder filterBuilder = new BooleanQuery.Builder();
            if (originalFilterQuery != null) {
                filterBuilder.add(originalFilterQuery, BooleanClause.Occur.MUST);
            }
            if ((tenantFilter = this.scope.filterOrNull(this.sessionContext.tenantIdentifier())) != null) {
                filterBuilder.add(tenantFilter, BooleanClause.Occur.MUST);
            }
            if (!this.routingKeys.isEmpty()) {
                Query routingKeysQuery = Queries.anyTerm(MetadataFields.routingKeyFieldName(), this.routingKeys);
                filterBuilder.add(routingKeysQuery, BooleanClause.Occur.MUST);
            }
            return (filter = filterBuilder.build()).clauses().isEmpty() ? null : filter;
        }

        @Override
        public PredicateRequestContext withNestedPath(String nestedPath) {
            return new FullPredicateRequestContext(nestedPath, this.scope, this.sessionContext, this.routingKeys, this.parameters);
        }

        @Override
        public NamedValues queryParameters() {
            return this.parameters;
        }
    }

    private static class LimitedPredicateRequestContext
    extends PredicateRequestContext {
        public LimitedPredicateRequestContext(String nestedPath) {
            super(nestedPath);
        }

        @Override
        public Query appendTenantAndRoutingFilters(Query originalFilterQuery) {
            throw new AssertionFailure("A tenant/routing filter requires session context.");
        }

        @Override
        public PredicateRequestContext withNestedPath(String nestedPath) {
            return new LimitedPredicateRequestContext(nestedPath);
        }

        @Override
        public NamedValues queryParameters() {
            return FailingQueryParameters.INSTANCE;
        }

        private static class FailingQueryParameters
        implements NamedValues {
            private static final FailingQueryParameters INSTANCE = new FailingQueryParameters();

            private FailingQueryParameters() {
            }

            public <T> T get(String parameterName, Class<T> parameterValueType) {
                throw new AssertionFailure("Accessing parameters requires session context.");
            }

            public <T> Optional<T> getOptional(String parameterName, Class<T> parameterValueType) {
                throw new AssertionFailure("Accessing parameters requires session context.");
            }
        }
    }
}

