/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.impl;

import io.smallrye.mutiny.Multi;
import io.smallrye.reactive.messaging.ChannelRegistar;
import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.PublisherDecorator;
import io.smallrye.reactive.messaging.connector.InboundConnector;
import io.smallrye.reactive.messaging.connector.OutboundConnector;
import io.smallrye.reactive.messaging.providers.DefaultPausableChannelConfiguration;
import io.smallrye.reactive.messaging.providers.extension.PausableChannelDecorator;
import io.smallrye.reactive.messaging.providers.helpers.CDIUtils;
import io.smallrye.reactive.messaging.providers.helpers.MultiUtils;
import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.providers.i18n.ProviderLogging;
import io.smallrye.reactive.messaging.providers.impl.ConcurrencyConnectorConfig;
import io.smallrye.reactive.messaging.providers.impl.ConnectorConfig;
import io.smallrye.reactive.messaging.providers.impl.ConnectorFactories;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Flow;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class ConfiguredChannelFactory
implements ChannelRegistar {
    protected final Config config;
    protected final ChannelRegistry registry;
    private final ConnectorFactories factories;
    @Inject
    Instance<PublisherDecorator> publisherDecoratorInstance;

    protected ConfiguredChannelFactory() {
        this.config = null;
        this.registry = null;
        this.factories = null;
    }

    @Inject
    public ConfiguredChannelFactory(ConnectorFactories factories, Instance<Config> config, @Any Instance<ChannelRegistry> registry) {
        this(factories, config, registry, true);
    }

    ConfiguredChannelFactory(ConnectorFactories factories, Instance<Config> config, @Any Instance<ChannelRegistry> registry, boolean logConnectors) {
        this.registry = (ChannelRegistry)registry.get();
        this.factories = factories;
        if (config.isUnsatisfied()) {
            this.config = null;
        } else {
            if (logConnectors) {
                ProviderLogging.log.foundIncomingConnectors(factories.getInboundConnectors().keySet());
                ProviderLogging.log.foundOutgoingConnectors(factories.getOutboundConnectors().keySet());
            }
            this.config = (Config)config.stream().findFirst().orElseThrow(ProviderExceptions.ex::illegalStateRetrieveConfig);
        }
    }

    static Map<String, ConnectorConfig> extractConfigurationFor(String prefix, Config root) {
        Iterable names = root.getPropertyNames();
        HashMap<String, ConnectorConfig> configs = new HashMap<String, ConnectorConfig>();
        names.forEach(key -> {
            if (key.startsWith(prefix)) {
                String name = key.substring(prefix.length());
                if (name.charAt(0) == '\"') {
                    name = name.substring(1, name.lastIndexOf(34));
                } else if (name.contains(".")) {
                    String tmp = name;
                    name = tmp.substring(0, tmp.indexOf(46));
                }
                if (!ConcurrencyConnectorConfig.isConcurrencyChannelName(name) || ConcurrencyConnectorConfig.getConcurrency(ConcurrencyConnectorConfig.stripChannelNameOfSeparator(name), root).isEmpty()) {
                    configs.put(name, new ConnectorConfig(prefix, root, name));
                }
            }
        });
        return configs;
    }

    public void initialize() {
        if (this.config == null) {
            ProviderLogging.log.skippingMPConfig();
            return;
        }
        ProviderLogging.log.channelManagerInitializing();
        Map<String, ConnectorConfig> sourceConfiguration = ConfiguredChannelFactory.extractConfigurationFor("mp.messaging.incoming.", this.config);
        Map<String, ConnectorConfig> sinkConfiguration = ConfiguredChannelFactory.extractConfigurationFor("mp.messaging.outgoing.", this.config);
        this.detectNameConflict(sourceConfiguration, sinkConfiguration);
        this.register(sourceConfiguration, sinkConfiguration);
    }

    private void detectNameConflict(Map<String, ConnectorConfig> sourceConfiguration, Map<String, ConnectorConfig> sinkConfiguration) {
        HashSet<String> sources = new HashSet<String>(sourceConfiguration.keySet());
        Set<String> sinks = sinkConfiguration.keySet();
        sources.retainAll(sinks);
        if (!sources.isEmpty()) {
            throw ProviderExceptions.ex.deploymentInvalidConfiguration(sources);
        }
    }

    void register(Map<String, ConnectorConfig> incomings, Map<String, ConnectorConfig> outgoings) {
        try {
            ConnectorConfig config;
            String channel;
            for (Map.Entry<String, ConnectorConfig> entry : incomings.entrySet()) {
                channel = entry.getKey();
                config = entry.getValue();
                if (config.getOptionalValue("enabled", Boolean.TYPE).orElse(true).booleanValue()) {
                    int concurrency = ConcurrencyConnectorConfig.getConcurrency(config).orElse(1);
                    if (concurrency <= 1) {
                        this.addPausableChannelConfiguration(channel, config);
                        this.registry.register(channel, this.createPublisher(channel, config), config.getOptionalValue("broadcast", Boolean.class).orElse(false).booleanValue());
                        continue;
                    }
                    for (int i = 0; i < concurrency; ++i) {
                        ConcurrencyConnectorConfig indexedConfig = new ConcurrencyConnectorConfig(config, i + 1);
                        String indexedChannel = indexedConfig.getIndexedChannel();
                        this.addPausableChannelConfiguration(indexedChannel, indexedConfig);
                        this.registry.register(channel, this.createPublisher(indexedChannel, indexedConfig), config.getOptionalValue("broadcast", Boolean.class).orElse(false).booleanValue());
                    }
                    continue;
                }
                ProviderLogging.log.incomingChannelDisabled(channel);
            }
            for (Map.Entry<String, ConnectorConfig> entry : outgoings.entrySet()) {
                channel = entry.getKey();
                config = entry.getValue();
                if (config.getOptionalValue("enabled", Boolean.TYPE).orElse(true).booleanValue()) {
                    this.addPausableChannelConfiguration(channel, config);
                    this.registry.register(channel, this.createSubscriber(channel, config), config.getOptionalValue("merge", Boolean.class).orElse(false).booleanValue());
                    continue;
                }
                ProviderLogging.log.outgoingChannelDisabled(channel);
            }
        }
        catch (RuntimeException e) {
            ProviderLogging.log.unableToCreatePublisherOrSubscriber(e);
            throw e;
        }
    }

    private void addPausableChannelConfiguration(String channel, ConnectorConfig config) {
        Instance select = this.publisherDecoratorInstance.select(PausableChannelDecorator.class, new Annotation[0]);
        if (select.isResolvable()) {
            PausableChannelDecorator pausableChannels = (PausableChannelDecorator)select.get();
            config.getOptionalValue("pausable", Boolean.class).ifPresent(pausable -> {
                if (pausable.booleanValue()) {
                    pausableChannels.addConfiguration(new DefaultPausableChannelConfiguration(channel, config.getOptionalValue("initially-paused", Boolean.class).orElse(false)));
                }
            });
        }
    }

    private static String getConnectorAttribute(Config config) {
        return (String)config.getValue("connector", String.class);
    }

    private Flow.Publisher<? extends Message<?>> createPublisher(String name, Config config) {
        String connector = ConfiguredChannelFactory.getConnectorAttribute(config);
        InboundConnector inboundConnector = this.factories.getInboundConnectors().get(connector);
        if (inboundConnector == null) {
            throw ProviderExceptions.ex.illegalArgumentUnknownConnector(name);
        }
        Multi publisher = MultiUtils.publisher(inboundConnector.getPublisher(config));
        for (PublisherDecorator decorator : CDIUtils.getSortedInstances(this.publisherDecoratorInstance)) {
            publisher = decorator.decorate(publisher, List.of(name), true);
        }
        return publisher;
    }

    private Flow.Subscriber<? extends Message<?>> createSubscriber(String name, Config config) {
        String connector = ConfiguredChannelFactory.getConnectorAttribute(config);
        OutboundConnector outboundConnector = this.factories.getOutboundConnectors().get(connector);
        if (outboundConnector == null) {
            throw ProviderExceptions.ex.illegalArgumentUnknownConnector(name);
        }
        return outboundConnector.getSubscriber(config);
    }
}

