
package com.acme.corp.tracker;

import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

/**
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 */
public class TypeDefinition extends SimpleResourceDefinition {

    public static final TypeDefinition INSTANCE = new TypeDefinition();

    protected static final SimpleAttributeDefinition TICK = new SimpleAttributeDefinitionBuilder(SubsystemExtension.TICK,
            ModelType.LONG).setAllowExpression(true).setXmlName(SubsystemExtension.TICK)
                    .setFlags(AttributeAccess.Flag.RESTART_ALL_SERVICES).setDefaultValue(new ModelNode(1000)).setRequired(false)
                    .build();

    public TypeDefinition() {
        super(SubsystemExtension.TYPE_PATH, SubsystemExtension.getResourceDescriptionResolver(SubsystemExtension.TYPE),
                TypeAddHandler.INSTANCE, TypeRemoveHandler.INSTANCE);
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute(TICK, null, TrackerTickHandler.INSTANCE);
    }

}
