/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.FieldSetReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.util.EnumSetBuilder;
import org.wildfly.clustering.marshalling.protostream.util.EnumSetFieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.Reflect;

public class EnumMapMarshaller<E extends Enum<E>>
implements ProtoStreamMarshaller<EnumMap<E, Object>> {
    static final Field ENUM_MAP_KEY_CLASS_FIELD = Reflect.findField(EnumMap.class, Class.class);
    private static final int ENUM_SET_INDEX = 1;
    private final FieldSetMarshaller<EnumSet<E>, EnumSetBuilder<E>> marshaller = new EnumSetFieldSetMarshaller();
    private final int valueIndex = this.marshaller.nextIndex(1);

    @Override
    public EnumMap<E, Object> readFrom(ProtoStreamReader reader) throws IOException {
        FieldSetReader<EnumSetBuilder<E>> enumReader = reader.createFieldSetReader(this.marshaller, 1);
        EnumSetBuilder<E> builder = this.marshaller.createInitialValue();
        LinkedList<Object> values = new LinkedList<Object>();
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            if (enumReader.contains(index)) {
                builder = enumReader.readField(builder);
                continue;
            }
            if (index == this.valueIndex) {
                values.add(reader.readAny());
                continue;
            }
            reader.skipField(tag);
        }
        EnumSet enumSet = (EnumSet)builder.get();
        Iterator enumValues = enumSet.iterator();
        EnumMap enumMap = new EnumMap(builder.getEnumClass());
        for (Object e : values) {
            enumMap.put((E)((Enum)enumValues.next()), e);
        }
        return enumMap;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, EnumMap<E, Object> map) throws IOException {
        EnumSet<E> set = EnumSet.noneOf(this.findEnumClass(map));
        set.addAll(map.keySet());
        writer.createFieldSetWriter(this.marshaller, 1).writeFields(set);
        for (Object value : map.values()) {
            writer.writeAny(this.valueIndex, value);
        }
    }

    @Override
    public Class<? extends EnumMap<E, Object>> getJavaClass() {
        return EnumMap.class;
    }

    private Class<E> findEnumClass(EnumMap<E, Object> map) {
        Iterator<E> values = map.keySet().iterator();
        if (values.hasNext()) {
            return ((Enum)values.next()).getDeclaringClass();
        }
        return Reflect.getValue(map, ENUM_MAP_KEY_CLASS_FIELD, Class.class);
    }
}

