/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scattered.impl;

import io.reactivex.rxjava3.core.Flowable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.AdvancedCache;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.SimpleClusteredVersion;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.manager.PreloadManager;
import org.infinispan.scattered.ScatteredVersionManager;
import org.infinispan.topology.ClusterTopologyManager;
import org.infinispan.util.concurrent.CompletionStages;
import org.reactivestreams.Publisher;

@Scope(value=Scopes.NAMED_CACHE)
public class ScatteredPreloadManager
extends PreloadManager {
    @Inject
    ScatteredVersionManager<?> scatteredVersionManager;
    @Inject
    ClusterTopologyManager clusterTopologyManager;

    @Override
    public void start() {
        super.start();
        this.initTopologyId();
    }

    private void initTopologyId() {
        int preloadedTopologyId = this.scatteredVersionManager.getPreloadedTopologyId();
        if (this.isFullyPreloaded()) {
            if (preloadedTopologyId > 0) {
                this.clusterTopologyManager.setInitialCacheTopologyId(((AdvancedCache)this.cache.wired()).getName(), preloadedTopologyId + 1);
            }
            return;
        }
        AtomicInteger maxTopologyId = new AtomicInteger(preloadedTopologyId);
        Publisher publisher = this.persistenceManager.publishEntries(false, true);
        CompletionStage stage = Flowable.fromPublisher(publisher).doOnNext(me -> {
            Metadata metadata = me.getMetadata();
            EntryVersion entryVersion = metadata.version();
            if (entryVersion instanceof SimpleClusteredVersion) {
                int entryTopologyId = ((SimpleClusteredVersion)entryVersion).getTopologyId();
                if (maxTopologyId.get() < entryTopologyId) {
                    maxTopologyId.updateAndGet(current -> Math.max(current, entryTopologyId));
                }
            }
        }).ignoreElements().toCompletionStage(null);
        CompletionStages.join(stage);
        if (maxTopologyId.get() > 0) {
            this.clusterTopologyManager.setInitialCacheTopologyId(((AdvancedCache)this.cache.wired()).getName(), maxTopologyId.get() + 1);
        }
    }
}

