/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.function;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.wildfly.common.function.ExceptionFunction;

public class Functions {
    private static final UnaryOperator<?> NULL_OPERATOR = Functions.constantOperator(null);
    private static final Function<?, ?> NULL_FUNCTION = Functions.constantFunction(null);

    private Functions() {
    }

    public static <T> UnaryOperator<T> whenNullFunction(final T replacement) {
        return new UnaryOperator<T>(){

            @Override
            public T apply(T value) {
                return Optional.ofNullable(value).orElse(replacement);
            }
        };
    }

    public static <T> UnaryOperator<T> whenNullFunction(final Supplier<T> factory) {
        return new UnaryOperator<T>(){

            @Override
            public T apply(T value) {
                return Optional.ofNullable(value).orElseGet(factory);
            }
        };
    }

    public static <R> UnaryOperator<R> nullOperator() {
        return NULL_OPERATOR;
    }

    public static <R> UnaryOperator<R> constantOperator(R result) {
        return new ConstantOperator<R>(result);
    }

    public static <T, R> Function<T, R> nullFunction() {
        return NULL_FUNCTION;
    }

    public static <T, R> Function<T, R> constantFunction(R result) {
        return new ConstantFunction(result);
    }

    public static <R> IntFunction<R> constantIntFunction(R result) {
        return new ConstantFunction(result);
    }

    public static <R> LongFunction<R> constantLongFunction(R result) {
        return new ConstantFunction(result);
    }

    public static <R> DoubleFunction<R> constantDoubleFunction(R result) {
        return new ConstantFunction(result);
    }

    public static <T, R, E extends Exception> Function<T, R> quiet(final ExceptionFunction<T, R, E> function, final BiFunction<T, Exception, RuntimeException> exceptionWrapper) {
        return new Function<T, R>(){

            @Override
            public R apply(T value) {
                try {
                    return function.apply(value);
                }
                catch (Exception e) {
                    throw (RuntimeException)exceptionWrapper.apply(value, e);
                }
            }
        };
    }

    static class ConstantOperator<R>
    extends ConstantFunction<R, R>
    implements UnaryOperator<R> {
        ConstantOperator(R result) {
            super(result);
        }
    }

    static class ConstantFunction<T, R>
    implements Function<T, R>,
    IntFunction<R>,
    LongFunction<R>,
    DoubleFunction<R> {
        private final R result;

        ConstantFunction(R result) {
            this.result = result;
        }

        @Override
        public R apply(T ignored) {
            return this.result;
        }

        @Override
        public R apply(double value) {
            return this.result;
        }

        @Override
        public R apply(long value) {
            return this.result;
        }

        @Override
        public R apply(int value) {
            return this.result;
        }
    }
}

