/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.analysis.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharFilterFactory;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenizerFactory;
import org.apache.lucene.analysis.core.KeywordTokenizerFactory;
import org.apache.lucene.util.ResourceLoader;
import org.apache.lucene.util.ResourceLoaderAware;
import org.apache.lucene.util.Version;
import org.hibernate.search.backend.lucene.analysis.impl.HibernateSearchNormalizerWrapper;
import org.hibernate.search.backend.lucene.analysis.impl.HibernateSearchResourceLoader;
import org.hibernate.search.backend.lucene.analysis.impl.TokenizerChain;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.engine.environment.classpath.spi.ClassLoaderHelper;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.engine.environment.classpath.spi.ResourceResolver;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class LuceneAnalysisComponentFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final String LUCENE_VERSION_PARAM = "luceneMatchVersion";
    private static final KeywordTokenizerFactory KEYWORD_TOKENIZER_FACTORY = new KeywordTokenizerFactory(Collections.emptyMap());
    private final Version luceneMatchVersion;
    private final ResourceLoader resourceLoader;

    public LuceneAnalysisComponentFactory(Version luceneMatchVersion, ClassResolver classResolver, ResourceResolver resourceResolver) {
        this.luceneMatchVersion = luceneMatchVersion;
        this.resourceLoader = new HibernateSearchResourceLoader(classResolver, resourceResolver);
    }

    public Analyzer createAnalyzer(TokenizerFactory tokenizerFactory, CharFilterFactory[] charFilterFactories, TokenFilterFactory[] filterFactories) {
        return new TokenizerChain(charFilterFactories, tokenizerFactory, filterFactories);
    }

    public Analyzer createNormalizer(String name, CharFilterFactory[] charFilterFactories, TokenFilterFactory[] filterFactories) {
        TokenizerChain normalizer = new TokenizerChain(charFilterFactories, (TokenizerFactory)KEYWORD_TOKENIZER_FACTORY, filterFactories);
        return this.wrapNormalizer(name, normalizer);
    }

    public Analyzer wrapNormalizer(String name, Analyzer normalizer) {
        return new HibernateSearchNormalizerWrapper(name, normalizer);
    }

    public TokenizerFactory createTokenizerFactory(Class<? extends TokenizerFactory> factoryClass, Map<String, String> parameters) throws IOException {
        return this.createAnalysisComponent(TokenizerFactory.class, factoryClass, parameters);
    }

    public CharFilterFactory createCharFilterFactory(Class<? extends CharFilterFactory> factoryClass, Map<String, String> parameters) throws IOException {
        return this.createAnalysisComponent(CharFilterFactory.class, factoryClass, parameters);
    }

    public TokenFilterFactory createTokenFilterFactory(Class<? extends TokenFilterFactory> factoryClass, Map<String, String> parameters) throws IOException {
        return this.createAnalysisComponent(TokenFilterFactory.class, factoryClass, parameters);
    }

    private <T> T createAnalysisComponent(Class<T> expectedFactoryClass, Class<? extends T> factoryClass, Map<String, String> parameters) throws IOException {
        try {
            Map<String, String> tokenMapsOfParameters = LuceneAnalysisComponentFactory.getMapOfParameters(parameters, this.luceneMatchVersion);
            Object tokenizerFactory = ClassLoaderHelper.instanceFromClass(expectedFactoryClass, factoryClass, tokenMapsOfParameters);
            this.injectResourceLoader(tokenizerFactory);
            return (T)tokenizerFactory;
        }
        catch (RuntimeException e) {
            throw log.unableToCreateAnalysisComponent(factoryClass, e.getMessage(), e);
        }
    }

    private void injectResourceLoader(Object processor) throws IOException {
        if (processor instanceof ResourceLoaderAware) {
            ((ResourceLoaderAware)processor).inform(this.resourceLoader);
        }
    }

    private static Map<String, String> getMapOfParameters(Map<String, String> params, Version luceneMatchVersion) {
        LinkedHashMap<String, String> mapOfParams = new LinkedHashMap<String, String>(params);
        params.put(LUCENE_VERSION_PARAM, luceneMatchVersion.toString());
        return mapOfParams;
    }
}

