/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.jgroups.protocols.Discovery;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ServiceDependency;

public class SocketDiscoveryProtocolResourceDefinition<A, P extends Discovery>
extends ProtocolResourceDefinition<P> {
    private final Function<InetSocketAddress, A> hostTransformer;

    SocketDiscoveryProtocolResourceDefinition(String name, Function<InetSocketAddress, A> hostTransformer, UnaryOperator<ResourceDescriptor> configurator, ResourceServiceConfigurator parentServiceConfigurator) {
        super(SocketDiscoveryProtocolResourceDefinition.pathElement(name), new ResourceDescriptorConfigurator(configurator), parentServiceConfigurator);
        this.hostTransformer = hostTransformer;
    }

    @Override
    public Map.Entry<Function<ProtocolConfiguration<P>, ProtocolConfiguration<P>>, Consumer<RequirementServiceBuilder<?>>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        final LinkedList<ServiceDependency> bindings = new LinkedList<ServiceDependency>();
        for (String bindingName : StringListAttributeDefinition.unwrapValue((ExpressionResolver)context, (ModelNode)Attribute.OUTBOUND_SOCKET_BINDINGS.resolveModelAttribute((ExpressionResolver)context, model))) {
            ServiceDependency binding = ServiceDependency.on((UnaryServiceDescriptor)OutboundSocketBinding.SERVICE_DESCRIPTOR, (String)bindingName);
            bindings.add(binding);
        }
        final Function<InetSocketAddress, A> hostTransformer = this.hostTransformer;
        return Map.entry(new UnaryOperator<ProtocolConfiguration<P>>(){

            @Override
            public ProtocolConfiguration<P> apply(ProtocolConfiguration<P> configuration) {
                return new AbstractProtocolResourceDefinition.ProtocolConfigurationDecorator<P>(configuration){

                    @Override
                    public P createProtocol(ProtocolStackConfiguration stackConfiguration) {
                        Discovery protocol = (Discovery)super.createProtocol(stackConfiguration);
                        if (!bindings.isEmpty()) {
                            ArrayList initialHosts = new ArrayList(bindings.size());
                            for (Supplier dependency : bindings) {
                                OutboundSocketBinding binding = (OutboundSocketBinding)dependency.get();
                                try {
                                    initialHosts.add(hostTransformer.apply(new InetSocketAddress(binding.getResolvedDestinationAddress(), binding.getDestinationPort())));
                                }
                                catch (UnknownHostException e) {
                                    throw JGroupsLogger.ROOT_LOGGER.failedToResolveSocketBinding(e, binding);
                                }
                            }
                            this.setValue(protocol, "initial_hosts", initialHosts);
                        }
                        return protocol;
                    }
                };
            }
        }, new Consumer<RequirementServiceBuilder<?>>(){

            @Override
            public void accept(RequirementServiceBuilder<?> builder) {
                for (ServiceDependency binding : bindings) {
                    binding.accept(builder);
                }
            }
        });
    }

    private static class ResourceDescriptorConfigurator
    implements UnaryOperator<ResourceDescriptor> {
        private final UnaryOperator<ResourceDescriptor> configurator;

        ResourceDescriptorConfigurator(UnaryOperator<ResourceDescriptor> configurator) {
            this.configurator = configurator;
        }

        @Override
        public ResourceDescriptor apply(ResourceDescriptor descriptor) {
            return ((ResourceDescriptor)this.configurator.apply(descriptor)).addAttributes(Attribute.class).setAddOperationTransformation((UnaryOperator)new ProtocolResourceDefinition.LegacyAddOperationTransformation(Attribute.class)).setOperationTransformation(ProtocolResourceDefinition.LEGACY_OPERATION_TRANSFORMER);
        }
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<StringListAttributeDefinition.Builder>
    {
        OUTBOUND_SOCKET_BINDINGS("socket-bindings"){

            @Override
            public StringListAttributeDefinition.Builder apply(StringListAttributeDefinition.Builder builder) {
                return (StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)builder.setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF})).setCapabilityReference((org.jboss.as.controller.CapabilityReferenceRecorder)CapabilityReferenceRecorder.builder(ProtocolResourceDefinition.CAPABILITY, (UnaryServiceDescriptor)OutboundSocketBinding.SERVICE_DESCRIPTOR).build());
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name) {
            this.definition = ((StringListAttributeDefinition.Builder)this.apply((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(name).setRequired(true)).setMinSize(1)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}))).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

