/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.externaldocs;

import com.fasterxml.jackson.databind.JsonNode;
import io.smallrye.openapi.api.models.ExternalDocumentationImpl;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class ExternalDocsReader {
    private ExternalDocsReader() {
    }

    public static ExternalDocumentation readExternalDocs(AnnotationScannerContext context, AnnotationValue annotationValue) {
        if (annotationValue == null) {
            return null;
        }
        return ExternalDocsReader.readExternalDocs(context, annotationValue.asNested());
    }

    public static ExternalDocumentation readExternalDocs(AnnotationScannerContext context, AnnotationInstance annotationInstance) {
        if (annotationInstance == null) {
            return null;
        }
        IoLogging.logger.annotation("@ExternalDocumentation");
        ExternalDocumentationImpl externalDoc = new ExternalDocumentationImpl();
        externalDoc.setDescription((String)context.annotations().value(annotationInstance, "description"));
        externalDoc.setUrl((String)context.annotations().value(annotationInstance, "url"));
        externalDoc.setExtensions(ExtensionReader.readExtensions(context, annotationInstance));
        return externalDoc;
    }

    public static ExternalDocumentation readExternalDocs(JsonNode node) {
        if (node == null) {
            return null;
        }
        ExternalDocumentationImpl externalDoc = new ExternalDocumentationImpl();
        externalDoc.setDescription(JsonUtil.stringProperty(node, "description"));
        externalDoc.setUrl(JsonUtil.stringProperty(node, "url"));
        ExtensionReader.readExtensions(node, externalDoc);
        return externalDoc;
    }
}

