/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.lang.instrument.ClassFileTransformer;
import java.security.AllPermission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.modules.AliasModuleSpec;
import org.jboss.modules.AssertionSetting;
import org.jboss.modules.ClassTransformer;
import org.jboss.modules.ConcreteModuleSpec;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.JLIClassTransformer;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.ModuleClassLoaderFactory;
import org.jboss.modules.ModuleDependencySpec;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.jboss.modules.Version;
import org.jboss.modules.filter.PathFilters;

public abstract class ModuleSpec {
    private final String name;

    ModuleSpec(String name) {
        this.name = name;
    }

    @Deprecated(forRemoval=true)
    public static Builder build(ModuleIdentifier moduleIdentifier) {
        return ModuleSpec.build(moduleIdentifier.toString());
    }

    public static Builder build(String name) {
        return ModuleSpec.build(name, true);
    }

    static Builder build(final String name, boolean addBaseDep) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        Builder builder = new Builder(){
            private String mainClass;
            private AssertionSetting assertionSetting = AssertionSetting.INHERIT;
            private final List<ResourceLoaderSpec> resourceLoaders = new ArrayList<ResourceLoaderSpec>(0);
            private final List<DependencySpec> dependencies = new ArrayList<DependencySpec>();
            private final Map<String, String> properties = new LinkedHashMap<String, String>(0);
            private final Map<String, List<String>> provides = new HashMap<String, List<String>>(0);
            private LocalLoader fallbackLoader;
            private ModuleClassLoaderFactory moduleClassLoaderFactory;
            private ClassTransformer classFileTransformer;
            private PermissionCollection permissionCollection = this.getAllPermission();
            private Version version;

            @Override
            public Builder setFallbackLoader(LocalLoader fallbackLoader) {
                this.fallbackLoader = fallbackLoader;
                return this;
            }

            @Override
            public Builder setMainClass(String mainClass) {
                this.mainClass = mainClass;
                return this;
            }

            @Override
            public Builder setAssertionSetting(AssertionSetting assertionSetting) {
                this.assertionSetting = assertionSetting == null ? AssertionSetting.INHERIT : assertionSetting;
                return this;
            }

            @Override
            public Builder addDependency(DependencySpec dependencySpec) {
                this.dependencies.add(dependencySpec);
                return this;
            }

            @Override
            public Builder addResourceRoot(ResourceLoaderSpec resourceLoader) {
                this.resourceLoaders.add(resourceLoader);
                return this;
            }

            @Override
            public Builder setModuleClassLoaderFactory(ModuleClassLoaderFactory moduleClassLoaderFactory) {
                this.moduleClassLoaderFactory = moduleClassLoaderFactory;
                return this;
            }

            @Override
            @Deprecated
            public Builder setClassFileTransformer(ClassFileTransformer classFileTransformer) {
                this.classFileTransformer = new JLIClassTransformer(classFileTransformer);
                return this;
            }

            @Override
            public Builder setClassFileTransformer(ClassTransformer transformer) {
                this.classFileTransformer = transformer;
                return this;
            }

            @Override
            public Builder addProperty(String name2, String value) {
                this.properties.put(name2, value);
                return this;
            }

            @Override
            public Builder setPermissionCollection(PermissionCollection permissionCollection) {
                this.permissionCollection = permissionCollection;
                return this;
            }

            @Override
            public Builder setVersion(Version version) {
                this.version = version;
                return this;
            }

            @Override
            public Builder addProvide(String serviceTypeName, String serviceImplClassName) {
                List<String> infos = this.provides.get(serviceTypeName);
                if (infos == null) {
                    infos = new ArrayList<String>(1);
                    this.provides.put(serviceTypeName, infos);
                }
                infos.add(serviceImplClassName);
                return this;
            }

            @Override
            public Version getVersion() {
                return this.version;
            }

            @Override
            public ModuleSpec create() {
                List<ResourceLoaderSpec> resourceLoaders;
                if (this.provides.isEmpty()) {
                    resourceLoaders = this.resourceLoaders;
                } else {
                    resourceLoaders = new ArrayList<ResourceLoaderSpec>(this.resourceLoaders.size() + 1);
                    resourceLoaders.add(new ResourceLoaderSpec(ResourceLoaders.createServiceResourceLoader(this.provides), PathFilters.acceptAll()));
                    resourceLoaders.addAll(this.resourceLoaders);
                }
                return new ConcreteModuleSpec(name, this.mainClass, this.assertionSetting, resourceLoaders.toArray(ResourceLoaderSpec.NO_RESOURCE_LOADERS), this.dependencies.toArray(this.dependencies.toArray(DependencySpec.NO_DEPENDENCIES)), this.fallbackLoader, this.moduleClassLoaderFactory, this.classFileTransformer, this.properties, this.permissionCollection, this.version);
            }

            @Override
            public String getName() {
                return name;
            }

            private Permissions getAllPermission() {
                Permissions permissions = new Permissions();
                permissions.add(new AllPermission());
                return permissions;
            }
        };
        if (addBaseDep) {
            builder.addDependency(ModuleDependencySpec.JAVA_BASE);
        }
        return builder;
    }

    @Deprecated(forRemoval=true)
    public static AliasBuilder buildAlias(ModuleIdentifier moduleIdentifier, ModuleIdentifier aliasTarget) {
        return ModuleSpec.buildAlias(moduleIdentifier.toString(), aliasTarget.toString());
    }

    public static AliasBuilder buildAlias(final String name, final String aliasName) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (aliasName == null) {
            throw new IllegalArgumentException("aliasName is null");
        }
        return new AliasBuilder(){

            @Override
            public ModuleSpec create() {
                return new AliasModuleSpec(name, aliasName);
            }

            @Override
            public String getName() {
                return null;
            }

            @Override
            public String getAliasName() {
                return null;
            }
        };
    }

    @Deprecated(forRemoval=true)
    public ModuleIdentifier getModuleIdentifier() {
        return ModuleIdentifier.fromString(this.name);
    }

    public String getName() {
        return this.name;
    }

    static final class ServiceInfo {
        private final String serviceTypeName;
        private final String implClassName;

        ServiceInfo(String serviceTypeName, String implClassName) {
            this.serviceTypeName = serviceTypeName;
            this.implClassName = implClassName;
        }

        String getServiceTypeName() {
            return this.serviceTypeName;
        }

        String getImplClassName() {
            return this.implClassName;
        }
    }

    public static interface AliasBuilder {
        public ModuleSpec create();

        @Deprecated(forRemoval=true)
        default public ModuleIdentifier getIdentifier() {
            return ModuleIdentifier.fromString(this.getName());
        }

        public String getName();

        @Deprecated(forRemoval=true)
        default public ModuleIdentifier getAliasTarget() {
            return ModuleIdentifier.fromString(this.getAliasName());
        }

        public String getAliasName();
    }

    public static interface Builder {
        public Builder setMainClass(String var1);

        public Builder setAssertionSetting(AssertionSetting var1);

        public Builder addDependency(DependencySpec var1);

        public Builder addResourceRoot(ResourceLoaderSpec var1);

        public ModuleSpec create();

        @Deprecated(forRemoval=true)
        default public ModuleIdentifier getIdentifier() {
            return ModuleIdentifier.fromString(this.getName());
        }

        public String getName();

        public Builder setFallbackLoader(LocalLoader var1);

        public Builder setModuleClassLoaderFactory(ModuleClassLoaderFactory var1);

        @Deprecated
        public Builder setClassFileTransformer(ClassFileTransformer var1);

        public Builder setClassFileTransformer(ClassTransformer var1);

        public Builder addProperty(String var1, String var2);

        public Builder setPermissionCollection(PermissionCollection var1);

        public Builder setVersion(Version var1);

        public Builder addProvide(String var1, String var2);

        public Version getVersion();
    }
}

