/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds;

import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.ds.TimeOut;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;

public class TimeOutImpl
extends org.jboss.jca.common.metadata.common.TimeOutImpl
implements TimeOut {
    private static final long serialVersionUID = 1L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    private final Boolean setTxQueryTimeout;
    private final Long queryTimeout;
    private final Long useTryLock;

    public TimeOutImpl(Long blockingTimeoutMillis, Long idleTimeoutMinutes, Integer allocationRetry, Long allocationRetryWaitMillis, Integer xaResourceTimeout, Boolean setTxQueryTimeout, Long queryTimeout, Long useTryLock) throws ValidateException {
        super(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout);
        this.setTxQueryTimeout = setTxQueryTimeout;
        this.queryTimeout = queryTimeout;
        this.useTryLock = useTryLock;
        this.validate();
    }

    public final Boolean isSetTxQueryTimeout() {
        return this.setTxQueryTimeout;
    }

    public final Long getQueryTimeout() {
        return this.queryTimeout;
    }

    public final Long getUseTryLock() {
        return this.useTryLock;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.queryTimeout == null ? 0 : this.queryTimeout.hashCode());
        result = 31 * result + (this.setTxQueryTimeout == null ? 0 : this.setTxQueryTimeout.hashCode());
        result = 31 * result + (this.useTryLock == null ? 0 : this.useTryLock.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof TimeOutImpl)) {
            return false;
        }
        TimeOutImpl other = (TimeOutImpl)obj;
        if (this.queryTimeout == null ? other.queryTimeout != null : !this.queryTimeout.equals(other.queryTimeout)) {
            return false;
        }
        if (this.setTxQueryTimeout == null ? other.setTxQueryTimeout != null : !this.setTxQueryTimeout.equals(other.setTxQueryTimeout)) {
            return false;
        }
        return !(this.useTryLock == null ? other.useTryLock != null : !this.useTryLock.equals(other.useTryLock));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<timeout>");
        if (this.blockingTimeoutMillis != null) {
            sb.append("<").append(TimeOut.Tag.BLOCKING_TIMEOUT_MILLIS).append(">");
            sb.append(this.blockingTimeoutMillis);
            sb.append("</").append(TimeOut.Tag.BLOCKING_TIMEOUT_MILLIS).append(">");
        }
        if (this.idleTimeoutMinutes != null) {
            sb.append("<").append(TimeOut.Tag.IDLE_TIMEOUT_MINUTES).append(">");
            sb.append(this.idleTimeoutMinutes);
            sb.append("</").append(TimeOut.Tag.IDLE_TIMEOUT_MINUTES).append(">");
        }
        if (this.setTxQueryTimeout != null && Boolean.TRUE.equals(this.setTxQueryTimeout)) {
            sb.append("<").append(TimeOut.Tag.SET_TX_QUERY_TIMEOUT).append("/>");
        }
        if (this.queryTimeout != null) {
            sb.append("<").append(TimeOut.Tag.QUERY_TIMEOUT).append(">");
            sb.append(this.queryTimeout);
            sb.append("</").append(TimeOut.Tag.QUERY_TIMEOUT).append(">");
        }
        if (this.useTryLock != null) {
            sb.append("<").append(TimeOut.Tag.USE_TRY_LOCK).append(">");
            sb.append(this.useTryLock);
            sb.append("</").append(TimeOut.Tag.USE_TRY_LOCK).append(">");
        }
        if (this.allocationRetry != null) {
            sb.append("<").append(TimeOut.Tag.ALLOCATION_RETRY).append(">");
            sb.append(this.allocationRetry);
            sb.append("</").append(TimeOut.Tag.ALLOCATION_RETRY).append(">");
        }
        if (this.allocationRetryWaitMillis != null) {
            sb.append("<").append(TimeOut.Tag.ALLOCATION_RETRY_WAIT_MILLIS).append(">");
            sb.append(this.allocationRetryWaitMillis);
            sb.append("</").append(TimeOut.Tag.ALLOCATION_RETRY_WAIT_MILLIS).append(">");
        }
        if (this.xaResourceTimeout != null) {
            sb.append("<").append(TimeOut.Tag.XA_RESOURCE_TIMEOUT).append(">");
            sb.append(this.xaResourceTimeout);
            sb.append("</").append(TimeOut.Tag.XA_RESOURCE_TIMEOUT).append(">");
        }
        sb.append("</timeout>");
        return sb.toString();
    }

    public void validate() throws ValidateException {
        if (this.queryTimeout != null && this.queryTimeout < 0L) {
            throw new ValidateException(bundle.invalidNegative(TimeOut.Tag.QUERY_TIMEOUT.getLocalName()));
        }
    }
}

