/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jgroups.protocols.MPING;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ServiceDependency;

public class MulticastSocketProtocolResourceDefinition
extends ProtocolResourceDefinition<MPING> {
    MulticastSocketProtocolResourceDefinition(String name, UnaryOperator<ResourceDescriptor> configurator, ResourceServiceConfigurator parentServiceConfigurator) {
        super(MulticastSocketProtocolResourceDefinition.pathElement(name), new ResourceDescriptorConfigurator(configurator), parentServiceConfigurator);
    }

    @Override
    public Map.Entry<Function<ProtocolConfiguration<MPING>, ProtocolConfiguration<MPING>>, Consumer<RequirementServiceBuilder<?>>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        final ServiceDependency binding = ServiceDependency.on((UnaryServiceDescriptor)SocketBinding.SERVICE_DESCRIPTOR, (String)Attribute.SOCKET_BINDING.resolveModelAttribute((ExpressionResolver)context, model).asString());
        return Map.entry(new UnaryOperator<ProtocolConfiguration<MPING>>(){

            @Override
            public ProtocolConfiguration<MPING> apply(ProtocolConfiguration<MPING> configuration) {
                return new AbstractProtocolResourceDefinition.ProtocolConfigurationDecorator<MPING>(configuration){

                    @Override
                    public MPING createProtocol(ProtocolStackConfiguration stackConfiguration) {
                        SocketBinding multicastBinding = (SocketBinding)binding.get();
                        MPING protocol = (MPING)super.createProtocol(stackConfiguration);
                        protocol.setBindAddr(multicastBinding.getAddress());
                        protocol.setMcastAddr(multicastBinding.getMulticastAddress());
                        protocol.setMcastPort(multicastBinding.getMulticastPort());
                        return protocol;
                    }

                    @Override
                    public Map<String, SocketBinding> getSocketBindings() {
                        SocketBinding multicastBinding = (SocketBinding)binding.get();
                        return Map.of("jgroups.mping.mcast_sock", multicastBinding, "jgroups.mping.mcast-send-sock", multicastBinding);
                    }
                };
            }
        }, binding);
    }

    private static class ResourceDescriptorConfigurator
    implements UnaryOperator<ResourceDescriptor> {
        private final UnaryOperator<ResourceDescriptor> configurator;

        ResourceDescriptorConfigurator(UnaryOperator<ResourceDescriptor> configurator) {
            this.configurator = configurator;
        }

        @Override
        public ResourceDescriptor apply(ResourceDescriptor descriptor) {
            return ((ResourceDescriptor)this.configurator.apply(descriptor)).addAttributes(Attribute.class);
        }
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        SOCKET_BINDING("socket-binding", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF})).setCapabilityReference((org.jboss.as.controller.CapabilityReferenceRecorder)CapabilityReferenceRecorder.builder(ProtocolResourceDefinition.CAPABILITY, (UnaryServiceDescriptor)SocketBinding.SERVICE_DESCRIPTOR).build());
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = ((SimpleAttributeDefinitionBuilder)this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setRequired(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}))).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

