/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import com.google.gson.Gson;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.AbstractElasticsearchJavaTimeFieldCodec;

public class ElasticsearchLocalTimeFieldCodec
extends AbstractElasticsearchJavaTimeFieldCodec<LocalTime> {
    private static final LocalDate EPOCH_DAY = LocalDate.of(1970, Month.JANUARY, 1);

    public ElasticsearchLocalTimeFieldCodec(Gson gson, DateTimeFormatter delegate) {
        super(gson, delegate);
    }

    @Override
    protected LocalTime nullUnsafeParse(String stringValue) {
        return LocalTime.parse(stringValue, this.formatter);
    }

    @Override
    protected Long nullUnsafeScalar(LocalTime value) {
        return value.atDate(EPOCH_DAY).toInstant(ZoneOffset.UTC).toEpochMilli();
    }
}

