/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.weld.ejb.component.stateful;

import java.io.IOException;
import org.infinispan.protostream.descriptors.WireType;
import org.jboss.as.ejb3.component.stateful.StatefulSerializedProxy;
import org.jboss.ejb.client.SessionID;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class StatefulSerializedProxyMarshaller
implements ProtoStreamMarshaller<StatefulSerializedProxy> {
    private static final int VIEW_NAME_INDEX = 1;
    private static final int SESSION_ID_INDEX = 2;

    public Class<? extends StatefulSerializedProxy> getJavaClass() {
        return StatefulSerializedProxy.class;
    }

    public StatefulSerializedProxy readFrom(ProtoStreamReader reader) throws IOException {
        String viewName = null;
        SessionID id = null;
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    viewName = reader.readString();
                    continue block4;
                }
                case 2: {
                    id = (SessionID)reader.readObject(SessionID.class);
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        return new StatefulSerializedProxy(viewName, id);
    }

    public void writeTo(ProtoStreamWriter writer, StatefulSerializedProxy proxy) throws IOException {
        SessionID id;
        String viewName = proxy.getViewName();
        if (viewName != null) {
            writer.writeString(1, viewName);
        }
        if ((id = proxy.getSessionID()) != null) {
            writer.writeObject(2, (Object)id);
        }
    }
}

