/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.spi.orb;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.spi.orb.DataCollector;
import com.sun.corba.se.spi.orb.PropertyParser;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class ParserImplBase {
    private ORBUtilSystemException wrapper = ORBUtilSystemException.get("orb.lifecycle");

    protected abstract PropertyParser makeParser();

    protected void complete() {
    }

    public void init(DataCollector coll) {
        PropertyParser parser = this.makeParser();
        coll.setParser(parser);
        Properties props = coll.getProperties();
        Map map = parser.parse(props);
        this.setFields(map);
    }

    private Field getAnyField(String name) {
        Field result = null;
        try {
            Class<?> cls = this.getClass();
            result = cls.getDeclaredField(name);
            while (result == null && (cls = cls.getSuperclass()) != null) {
                result = cls.getDeclaredField(name);
            }
        }
        catch (Exception exc) {
            throw this.wrapper.fieldNotFound(exc, (Object)name);
        }
        if (result == null) {
            throw this.wrapper.fieldNotFound(name);
        }
        return result;
    }

    protected void setFields(Map map) {
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            final String name = (String)entry.getKey();
            final Object value = entry.getValue();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IllegalAccessException, IllegalArgumentException {
                        Field field = ParserImplBase.this.getAnyField(name);
                        field.setAccessible(true);
                        field.set(ParserImplBase.this, value);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException exc) {
                throw this.wrapper.errorSettingField(exc.getCause(), (Object)name, (Object)value.toString());
            }
        }
        this.complete();
    }
}

