/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import java.util.List;
import org.wildfly.clustering.server.GroupMember;

public interface GroupMembership<M extends GroupMember>
extends org.wildfly.clustering.server.GroupMembership<M> {
    public int getCoordinatorIndex();

    default public M getCoordinator() {
        return (M)((GroupMember)this.getMembers().get(this.getCoordinatorIndex()));
    }

    public static <M extends GroupMember> GroupMembership<M> singleton(M member) {
        final List<M> members = List.of(member);
        return new GroupMembership<M>(){

            @Override
            public int getCoordinatorIndex() {
                return 0;
            }

            public List<M> getMembers() {
                return members;
            }

            public int hashCode() {
                return this.getCoordinator().hashCode();
            }

            public boolean equals(Object object) {
                if (!(object instanceof GroupMembership)) {
                    return false;
                }
                GroupMembership membership = (GroupMembership)object;
                return members.equals(membership.getMembers());
            }

            public String toString() {
                return members.toString();
            }
        };
    }
}

