/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConfiguration;

public final class AMQPFederationConsumerConfiguration {
    private final Map<String, Object> properties;
    private final AMQPFederationConfiguration configuration;

    public AMQPFederationConsumerConfiguration(AMQPFederationConfiguration configuration, Map<String, ?> properties) {
        Objects.requireNonNull(configuration, "Federation configuration cannot be null");
        this.configuration = configuration;
        this.properties = properties == null || properties.isEmpty() ? Collections.EMPTY_MAP : Collections.unmodifiableMap(new HashMap(properties));
    }

    public int getReceiverCredits() {
        Object property = this.properties.get("amqpCredits");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.configuration.getReceiverCredits();
    }

    public int getReceiverCreditsLow() {
        Object property = this.properties.get("amqpLowCredits");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.configuration.getReceiverCreditsLow();
    }

    public int getPullReceiverBatchSize() {
        Object property = this.properties.get("amqpPullConsumerCredits");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.configuration.getPullReceiverBatchSize();
    }

    public int getLargeMessageThreshold() {
        Object property = this.properties.get("minLargeMessageSize");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.configuration.getLargeMessageThreshold();
    }

    public int getLinkAttachTimeout() {
        Object property = this.properties.get("attach-timeout");
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof String) {
            return Integer.parseInt((String)property);
        }
        return this.configuration.getLinkAttachTimeout();
    }

    public boolean isCoreMessageTunnelingEnabled() {
        Object property = this.properties.get("tunnel-core-messages");
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof String) {
            return Boolean.parseBoolean((String)property);
        }
        return this.configuration.isCoreMessageTunnelingEnabled();
    }

    public boolean isIgnoreSubscriptionFilters() {
        Object property = this.properties.get("ignoreQueueConsumerFilters");
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof String) {
            return Boolean.parseBoolean((String)property);
        }
        return this.configuration.isIgnoreSubscriptionFilters();
    }

    public boolean isIgnoreSubscriptionPriorities() {
        Object property = this.properties.get("ignoreQueueConsumerPriorities");
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof String) {
            return Boolean.parseBoolean((String)property);
        }
        return this.configuration.isIgnoreSubscriptionPriorities();
    }
}

