/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.models.security;

import io.smallrye.openapi.api.models.ModelImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;

public class SecurityRequirementImpl
extends LinkedHashMap<String, List<String>>
implements SecurityRequirement,
ModelImpl {
    private static final long serialVersionUID = -2336114397712664136L;

    public SecurityRequirement addScheme(String securitySchemeName, String scope) {
        if (scope == null) {
            this.addScheme(securitySchemeName);
        } else {
            this.addScheme(securitySchemeName, new ArrayList<String>(Collections.singletonList(scope)));
        }
        return this;
    }

    public SecurityRequirement addScheme(String securitySchemeName, List<String> scopes) {
        if (scopes == null) {
            scopes = new ArrayList<String>(0);
        }
        this.put(securitySchemeName, scopes);
        return this;
    }

    public SecurityRequirement addScheme(String securitySchemeName) {
        this.addScheme(securitySchemeName, (List<String>)null);
        return this;
    }

    public void removeScheme(String securitySchemeName) {
        this.remove(securitySchemeName);
    }

    public Map<String, List<String>> getSchemes() {
        return Collections.unmodifiableMap(this);
    }

    public void setSchemes(Map<String, List<String>> items) {
        this.clear();
        items.forEach(this::addScheme);
    }
}

