/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.ReaderInterceptor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.core.interception.jaxrs.ServerReaderInterceptorContext;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.MarshalledEntity;
import org.jboss.resteasy.spi.ReaderException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.ValueInjector;
import org.jboss.resteasy.spi.interception.JaxrsInterceptorRegistry;
import org.jboss.resteasy.spi.interception.JaxrsInterceptorRegistryListener;
import org.jboss.resteasy.spi.util.Types;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;
import org.jboss.resteasy.util.InputStreamToByteArray;
import org.jboss.resteasy.util.ThreadLocalStack;

public class MessageBodyParameterInjector
implements ValueInjector,
JaxrsInterceptorRegistryListener {
    private static ThreadLocalStack<Object> bodyStack = new ThreadLocalStack();
    private Class type;
    private Type genericType;
    private Annotation[] annotations;
    private ResteasyProviderFactory factory;
    private Class declaringClass;
    private AccessibleObject target;
    private ReaderInterceptor[] interceptors;
    private boolean isMarshalledEntity;

    public static void pushBody(Object o) {
        bodyStack.push(o);
    }

    public static Object getBody() {
        return bodyStack.get();
    }

    public static Object popBody() {
        return bodyStack.pop();
    }

    public static int bodyCount() {
        return bodyStack.size();
    }

    public static void clearBodies() {
        bodyStack.clear();
    }

    public MessageBodyParameterInjector(Class declaringClass, AccessibleObject target, Class type, Type genericType, Annotation[] annotations, ResteasyProviderFactory factory) {
        this.factory = factory;
        this.target = target;
        this.declaringClass = declaringClass;
        if (type.equals(MarshalledEntity.class)) {
            if (genericType == null || !(genericType instanceof ParameterizedType)) {
                throw new RuntimeException(Messages.MESSAGES.marshalledEntityMustHaveTypeInfo());
            }
            this.isMarshalledEntity = true;
            ParameterizedType param = (ParameterizedType)genericType;
            this.genericType = param.getActualTypeArguments()[0];
            this.type = Types.getRawType((Type)this.genericType);
        } else {
            this.type = type;
            this.genericType = genericType;
        }
        this.annotations = annotations;
        this.interceptors = (ReaderInterceptor[])this.factory.getServerReaderInterceptorRegistry().postMatch(this.declaringClass, this.target);
        this.factory.getServerReaderInterceptorRegistry().getListeners().add(this);
    }

    public void registryUpdated(JaxrsInterceptorRegistry registry, JaxrsInterceptorRegistry.InterceptorFactory factory) {
        this.interceptors = (ReaderInterceptor[])this.factory.getServerReaderInterceptorRegistry().postMatch(this.declaringClass, this.target);
    }

    protected ReaderInterceptor[] getReaderInterceptors() {
        return this.interceptors;
    }

    public boolean isFormData(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (mediaType.isWildcardType() || mediaType.isWildcardSubtype() || !mediaType.isCompatible(MediaType.APPLICATION_FORM_URLENCODED_TYPE)) {
            return false;
        }
        if (!MultivaluedMap.class.isAssignableFrom(type)) {
            return false;
        }
        if (genericType == null) {
            return true;
        }
        if (!(genericType instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType params = (ParameterizedType)genericType;
        if (params.getActualTypeArguments().length != 2) {
            return false;
        }
        return params.getActualTypeArguments()[0].equals(String.class) && params.getActualTypeArguments()[1].equals(String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object inject(HttpRequest request, HttpResponse response, boolean unwrapAsync) {
        MultivaluedMap map;
        Object o = MessageBodyParameterInjector.getBody();
        if (o != null) {
            return o;
        }
        MediaType mediaType = request.getHttpHeaders().getMediaType();
        if (mediaType == null) {
            mediaType = MediaType.WILDCARD_TYPE;
        }
        InputStream is = null;
        if (MediaType.APPLICATION_FORM_URLENCODED_TYPE.equals((Object)mediaType) && request.formParametersRead() && (map = request.getDecodedFormParameters()) != null) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                sb.append(key);
                List values = (List)entry.getValue();
                for (String value : values) {
                    if (!"".equals(value)) {
                        sb.append("=").append(value);
                    }
                    sb.append("&");
                }
            }
            if (sb.length() > 0 && '&' == sb.charAt(sb.length() - 1)) {
                sb.deleteCharAt(sb.length() - 1);
            }
            String charset = "UTF-8";
            if (mediaType.getParameters().get("charset") != null) {
                charset = (String)mediaType.getParameters().get("charset");
            }
            try {
                is = new ByteArrayInputStream(sb.toString().getBytes(charset));
            }
            catch (Exception e) {
                LogMessages.LOGGER.charsetUnavailable(charset);
            }
        }
        try {
            Object obj;
            if (is == null) {
                is = request.getInputStream();
            }
            if (this.isMarshalledEntity) {
                is = new InputStreamToByteArray(is);
            }
            ServerReaderInterceptorContext messageBodyReaderContext = new ServerReaderInterceptorContext(this.getReaderInterceptors(), this.factory, this.type, this.genericType, this.annotations, mediaType, (MultivaluedMap<String, String>)request.getMutableHeaders(), is, request);
            RESTEasyTracingLogger tracingLogger = RESTEasyTracingLogger.getInstance(request);
            long timestamp = tracingLogger.timestamp("RI_SUMMARY");
            try {
                obj = messageBodyReaderContext.proceed();
            }
            catch (Throwable throwable) {
                tracingLogger.logDuration("RI_SUMMARY", timestamp, messageBodyReaderContext.getProcessedInterceptorCount());
                throw throwable;
            }
            tracingLogger.logDuration("RI_SUMMARY", timestamp, messageBodyReaderContext.getProcessedInterceptorCount());
            if (this.isMarshalledEntity) {
                InputStreamToByteArray isba = (InputStreamToByteArray)is;
                final byte[] bytes = isba.toByteArray();
                return new MarshalledEntity(){
                    final /* synthetic */ MessageBodyParameterInjector this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public byte[] getMarshalledBytes() {
                        return bytes;
                    }

                    public Object getEntity() {
                        return obj;
                    }
                };
            }
            return obj;
        }
        catch (Exception e) {
            if (e instanceof ReaderException) {
                throw (ReaderException)e;
            }
            throw new ReaderException((Throwable)e);
        }
    }

    public Object inject(boolean unwrapAsync) {
        throw new RuntimeException(Messages.MESSAGES.illegalToInjectMessageBody(this.target));
    }
}

