/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.util.List;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

public class ModuleAliasChecker {
    static String getTargetModule(String identifier) {
        if (identifier.startsWith("javax.") && identifier.contains(".api")) {
            ModuleLoader moduleLoader = Module.getBootModuleLoader();
            try {
                Module module = moduleLoader.loadModule(identifier);
                String moduleName = module.getName();
                if (!moduleName.equals(identifier)) {
                    return moduleName;
                }
            }
            catch (RuntimeException | ModuleLoadException throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static void checkModuleAliasesForDependencies(List<ModuleDependency> dependencies, MessageContext context, String deploymentName) {
        for (ModuleDependency dependency : dependencies) {
            String identifier = dependency.getIdentifier().toString();
            ModuleAliasChecker.checkModuleAlias(context, deploymentName, identifier, false);
        }
    }

    public static void checkModuleAliasesForExclusions(List<ModuleIdentifier> identifiers, MessageContext context, String deploymentName) {
        for (ModuleIdentifier identifier : identifiers) {
            ModuleAliasChecker.checkModuleAlias(context, deploymentName, identifier.toString(), true);
        }
    }

    private static void checkModuleAlias(MessageContext context, String deploymentName, String identifier, boolean exclusions) {
        String targetModule = ModuleAliasChecker.getTargetModule(identifier);
        if (targetModule != null) {
            if (exclusions) {
                ServerLogger.DEPLOYMENT_LOGGER.aliasAddedAsExclusion(identifier, deploymentName, context.toString(), targetModule.toString());
            } else {
                ServerLogger.DEPLOYMENT_LOGGER.aliasAddedAsDependency(identifier, deploymentName, context.toString(), targetModule.toString());
            }
        }
    }

    public static enum MessageContext {
        JBOSS_DEPLOYMENT_STRUCTURE_CONTEXT("jboss-deployment-structure.xml"),
        MANIFEST_CONTEXT("MANIFEST.MF");

        private final String context;

        private MessageContext(String context) {
            this.context = context;
        }

        public String toString() {
            return this.context;
        }
    }
}

